/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.actions;

public final class Action<V> {
    private final Type type;
    private final V value;

    Action(Type type, V value) {
        this.type = type;
        this.value = value;
    }

    public Type type() {
        return this.type;
    }

    public V value() {
        return this.value;
    }

    public String toString() {
        return this.type.toString() + ": " + this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (this.type != action.type) {
            return false;
        }
        return this.value.equals(action.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public static enum Type {
        BASE_RESPONSE_RECEIVED,
        SOFT_RESET,
        HARD_RESET,
        NEW_CONVERSATION_SUCCESS,
        INBOX_OPENED,
        COMPOSER_OPENED,
        CONVERSATION_OPENED,
        TEAM_PRESENCE_UPDATED,
        CONVERSATION_MARKED_AS_READ,
        CONVERSATION_MARKED_AS_DISMISSED,
        UNREAD_CONVERSATIONS_SUCCESS,
        FETCH_INBOX_REQUEST,
        FETCH_INBOX_BEFORE_DATE_REQUEST,
        FETCH_INBOX_SUCCESS,
        FETCH_INBOX_FAILED,
        FETCH_CONVERSATION_SUCCESS,
        CONVERSATION_REPLY_SUCCESS,
        APP_ENTERED_BACKGROUND,
        APP_ENTERED_FOREGROUND,
        SET_LAUNCHER_VISIBILITY,
        SET_IN_APP_NOTIFICATION_VISIBILITY,
        ACTIVITY_READY_FOR_VIEW_ATTACHMENT,
        ACTIVITY_PAUSED,
        ACTIVITY_STOPPED,
        SESSION_STARTED,
        CREATE_CONVERSATION_EVENT_RECEIVED;

    }
}

