/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.nexus.NexusConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class Config {
    public static final String DEFAULT_COLOR_KEY = "default";
    public static final int DEFAULT_RATE_LIMIT_COUNT = 100;
    public static final long DEFAULT_RATE_LIMIT_PERIOD_MS = TimeUnit.MINUTES.toMillis(1L);
    public static final long DEFAULT_CACHE_MAX_AGE_MS = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_SESSION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(20L);
    public static final long DEFAULT_SOFT_RESET_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFAULT_BATCH_USER_UPDATE_PERIOD_MS = TimeUnit.SECONDS.toMillis(1L);
    public static final long DEFAULT_PING_DELAY_MS = TimeUnit.SECONDS.toMillis(1L);
    public static final Config NULL = new Config();
    private final String name;
    private final String baseColor;
    private final boolean metricsEnabled;
    private final boolean audioEnabled;
    private final boolean isFirstRequest;
    private final boolean inboundMessages;
    private final boolean showPoweredBy;
    private final boolean backgroundRequestsEnabled;
    private final NexusConfig realTimeConfig;
    private final int rateLimitCount;
    private final long rateLimitPeriodMs;
    private final long userUpdateCacheMaxAgeMs;
    private final long newSessionThresholdMs;
    private final long softResetTimeoutMs;
    private final long batchUserUpdatePeriodMs;
    private final long pingDelayMs;
    private final String messengerBackground;
    private final String welcomeMessage;
    private final String locale;
    private final Set<String> features;

    public Config() {
        this(new Builder());
    }

    Config(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.baseColor = builder.base_color == null ? DEFAULT_COLOR_KEY : builder.base_color;
        this.realTimeConfig = builder.real_time_config == null ? new NexusConfig() : builder.real_time_config.build();
        this.rateLimitPeriodMs = builder.local_rate_limit_period == null ? DEFAULT_RATE_LIMIT_PERIOD_MS : TimeUnit.SECONDS.toMillis(builder.local_rate_limit_period);
        this.rateLimitCount = builder.local_rate_limit == null ? 100 : builder.local_rate_limit;
        this.newSessionThresholdMs = builder.new_session_threshold == null ? DEFAULT_SESSION_TIMEOUT_MS : TimeUnit.SECONDS.toMillis(builder.new_session_threshold);
        this.userUpdateCacheMaxAgeMs = builder.user_update_dup_cache_max_age == null ? DEFAULT_CACHE_MAX_AGE_MS : TimeUnit.SECONDS.toMillis(builder.user_update_dup_cache_max_age);
        this.softResetTimeoutMs = builder.soft_reset_timeout == null ? DEFAULT_SOFT_RESET_TIMEOUT_MS : TimeUnit.SECONDS.toMillis(builder.soft_reset_timeout);
        this.batchUserUpdatePeriodMs = builder.batch_user_update_period == null ? DEFAULT_BATCH_USER_UPDATE_PERIOD_MS : (long)(builder.batch_user_update_period.floatValue() * 1000.0f);
        this.pingDelayMs = builder.ping_delay == null ? DEFAULT_PING_DELAY_MS : (long)(builder.ping_delay.floatValue() * 1000.0f);
        this.welcomeMessage = builder.welcome_message_plain_text == null ? "" : builder.welcome_message_plain_text;
        this.messengerBackground = builder.messenger_background == null ? "" : builder.messenger_background;
        this.locale = builder.locale == null ? "" : builder.locale;
        this.isFirstRequest = builder.is_first_request == null ? false : builder.is_first_request;
        this.inboundMessages = builder.inbound_messages == null ? false : builder.inbound_messages;
        this.showPoweredBy = builder.show_powered_by == null ? true : builder.show_powered_by;
        this.audioEnabled = builder.audio_enabled == null ? true : builder.audio_enabled;
        this.metricsEnabled = builder.metrics_enabled == null ? true : builder.metrics_enabled;
        this.backgroundRequestsEnabled = builder.background_requests_enabled == null ? true : builder.background_requests_enabled;
        this.features = builder.features == null ? new HashSet() : builder.features;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public long getUserUpdateCacheMaxAge() {
        return this.userUpdateCacheMaxAgeMs;
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public long getRateLimitPeriod() {
        return this.rateLimitPeriodMs;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public long getNewSessionThreshold() {
        return this.newSessionThresholdMs;
    }

    public long getBatchUserUpdatePeriod() {
        return this.batchUserUpdatePeriodMs;
    }

    public long getPingDelayMs() {
        return this.pingDelayMs;
    }

    public long getSoftResetTimeout() {
        return this.softResetTimeoutMs;
    }

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getMessengerBackground() {
        return this.messengerBackground;
    }

    public String getLocale() {
        return this.locale;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public boolean isBackgroundRequestsEnabled() {
        return this.backgroundRequestsEnabled;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.metricsEnabled != config.metricsEnabled) {
            return false;
        }
        if (this.audioEnabled != config.audioEnabled) {
            return false;
        }
        if (this.isFirstRequest != config.isFirstRequest) {
            return false;
        }
        if (this.inboundMessages != config.inboundMessages) {
            return false;
        }
        if (this.showPoweredBy != config.showPoweredBy) {
            return false;
        }
        if (this.backgroundRequestsEnabled != config.backgroundRequestsEnabled) {
            return false;
        }
        if (this.rateLimitCount != config.rateLimitCount) {
            return false;
        }
        if (this.rateLimitPeriodMs != config.rateLimitPeriodMs) {
            return false;
        }
        if (this.userUpdateCacheMaxAgeMs != config.userUpdateCacheMaxAgeMs) {
            return false;
        }
        if (this.newSessionThresholdMs != config.newSessionThresholdMs) {
            return false;
        }
        if (this.softResetTimeoutMs != config.softResetTimeoutMs) {
            return false;
        }
        if (this.batchUserUpdatePeriodMs != config.batchUserUpdatePeriodMs) {
            return false;
        }
        if (this.pingDelayMs != config.pingDelayMs) {
            return false;
        }
        if (!this.name.equals(config.name)) {
            return false;
        }
        if (!this.baseColor.equals(config.baseColor)) {
            return false;
        }
        if (!this.realTimeConfig.equals((Object)config.realTimeConfig)) {
            return false;
        }
        if (!this.messengerBackground.equals(config.messengerBackground)) {
            return false;
        }
        if (!this.welcomeMessage.equals(config.welcomeMessage)) {
            return false;
        }
        if (!this.locale.equals(config.locale)) {
            return false;
        }
        return this.features.equals(config.features);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.baseColor.hashCode();
        result = 31 * result + (this.metricsEnabled ? 1 : 0);
        result = 31 * result + (this.audioEnabled ? 1 : 0);
        result = 31 * result + (this.isFirstRequest ? 1 : 0);
        result = 31 * result + (this.inboundMessages ? 1 : 0);
        result = 31 * result + (this.showPoweredBy ? 1 : 0);
        result = 31 * result + (this.backgroundRequestsEnabled ? 1 : 0);
        result = 31 * result + this.realTimeConfig.hashCode();
        result = 31 * result + this.rateLimitCount;
        result = 31 * result + (int)(this.rateLimitPeriodMs ^ this.rateLimitPeriodMs >>> 32);
        result = 31 * result + (int)(this.userUpdateCacheMaxAgeMs ^ this.userUpdateCacheMaxAgeMs >>> 32);
        result = 31 * result + (int)(this.newSessionThresholdMs ^ this.newSessionThresholdMs >>> 32);
        result = 31 * result + (int)(this.softResetTimeoutMs ^ this.softResetTimeoutMs >>> 32);
        result = 31 * result + (int)(this.batchUserUpdatePeriodMs ^ this.batchUserUpdatePeriodMs >>> 32);
        result = 31 * result + (int)(this.pingDelayMs ^ this.pingDelayMs >>> 32);
        result = 31 * result + this.messengerBackground.hashCode();
        result = 31 * result + this.welcomeMessage.hashCode();
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + this.features.hashCode();
        return result;
    }

    public static final class Builder {
        String name;
        String base_color;
        Boolean metrics_enabled;
        Boolean audio_enabled;
        Boolean background_requests_enabled;
        Boolean is_first_request;
        Boolean inbound_messages;
        Boolean show_powered_by;
        NexusConfig.Builder real_time_config;
        Integer local_rate_limit;
        Long user_update_dup_cache_max_age;
        Long local_rate_limit_period;
        Long new_session_threshold;
        Long soft_reset_timeout;
        Float batch_user_update_period;
        Float ping_delay;
        String messenger_background;
        String welcome_message_plain_text;
        String locale;
        Set<String> features;

        public Config build() {
            return new Config(this);
        }
    }
}

