/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.ConversationReactionListener;
import io.intercom.android.sdk.activities.FullScreenInAppPresenter;
import io.intercom.android.sdk.activities.InAppToolbarListener;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomNoteActivity
extends IntercomBaseActivity
implements View.OnClickListener {
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String LAST_PARTICIPANT = "last_participant";
    private final FullScreenInAppPresenter presenter = new FullScreenInAppPresenter();
    Part part;
    private LastParticipatingAdmin lastParticipatingAdmin;
    String conversationId;
    View composerLayout;
    private LinearLayout noteLayout;
    ReactionInputView reactionComposer;
    MetricTracker metricTracker;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_note);
        this.noteLayout = (LinearLayout)this.findViewById(R.id.note_layout);
        this.noteLayout.setVisibility(4);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        IntercomToolbar intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        intercomToolbar.setListener(new InAppToolbarListener((Activity)this));
        this.part = new Part();
        this.lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        Injector injector = Injector.get();
        Api api = injector.getApi();
        this.metricTracker = injector.getMetricTracker();
        TimeFormatter timeFormatter = new TimeFormatter((Context)this, injector.getTimeProvider());
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            data.setClassLoader(Part.class.getClassLoader());
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                String teamMateName = "";
                if (this.part != null && this.part.getParticipant() != null) {
                    teamMateName = this.part.getParticipant().getForename();
                }
                String appName = injector.getAppConfigProvider().get().getName();
                CharSequence title = Phrase.from((Context)this, R.string.intercom_teammate_from_company).put("name", teamMateName).put("company", appName).format();
                intercomToolbar.setTitle(title);
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID);
                injector.getStore().dispatch(Actions.conversationMarkedAsRead(this.conversationId));
                api.markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
                if (!LastParticipatingAdmin.isNull(this.lastParticipatingAdmin)) {
                    intercomToolbar.setSubtitle(timeFormatter.getAdminActiveStatus(this.lastParticipatingAdmin, injector.getAppConfigProvider()));
                }
            }
        }
        intercomToolbar.setUpNoteToolbar(this.part.getParticipant(), this.lastParticipatingAdmin.isActive(), new ActiveStatePresenter());
        ViewHolderGenerator viewHolderGenerator = new ViewHolderGenerator(new UploadingImageCache(), api, injector.getAppConfigProvider(), this.conversationId);
        BlocksViewHolder noteHolder = viewHolderGenerator.getNoteHolder();
        this.composerLayout = this.findViewById(R.id.note_composer_container);
        final ContentAwareScrollView noteView = (ContentAwareScrollView)this.findViewById(R.id.note_view);
        LinearLayout partsView = ViewHolderGenerator.createPartsLayout(noteHolder, this.part, (Context)this);
        noteView.addView(BlockUtils.getBlockView((ViewGroup)noteView, partsView, (Context)this));
        if (!ReactionReply.isNull(this.part.getReactionReply())) {
            final ConversationReactionListener reactionListener = new ConversationReactionListener(MetricTracker.ReactionLocation.IN_APP, this.part.getId(), this.conversationId, Injector.get().getApi(), this.metricTracker);
            noteView.setListener(new ContentAwareScrollView.Listener(){

                @Override
                public void onBottomReached() {
                    noteView.setListener(null);
                    IntercomNoteActivity.this.composerLayout.setVisibility(0);
                    IntercomNoteActivity.this.reactionComposer.setUpReactions(IntercomNoteActivity.this.part.getReactionReply(), true, reactionListener);
                }

                @Override
                public void onScrollChanged(int scrollPosition) {
                }
            });
            this.reactionComposer.preloadReactionImages(this.part.getReactionReply());
        }
        View background = this.getWindow().getDecorView();
        background.setAlpha(0.0f);
        background.animate().alpha(1.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomNoteActivity.this.animateContent();
                if (ReactionReply.isNull(IntercomNoteActivity.this.part.getReactionReply())) {
                    IntercomNoteActivity.this.composerLayout.setVisibility(0);
                    View touchTarget = IntercomNoteActivity.this.findViewById(R.id.note_touch_target);
                    touchTarget.setOnClickListener((View.OnClickListener)IntercomNoteActivity.this);
                    IntercomNoteActivity.this.findViewById(R.id.composer_input_view).setVisibility(0);
                }
            }
        }).start();
    }

    void animateContent() {
        this.noteLayout.setScaleX(0.9f);
        this.noteLayout.setScaleY(0.9f);
        this.noteLayout.setAlpha(0.0f);
        this.noteLayout.setVisibility(0);
        this.noteLayout.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(200L).start();
    }

    public static Intent buildNoteIntent(Context context, Part part, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomNoteActivity.class);
        intent.putExtra(PARCEL_PART, (Parcelable)part);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        intent.setFlags(0x10000000);
        intent.setExtrasClassLoader(Part.class.getClassLoader());
        return intent;
    }

    public void onBackPressed() {
        this.presenter.closeWindow((Activity)this);
        this.metricTracker.closedInAppFromFull(this.conversationId, this.part.getId());
    }

    public void onClick(View v) {
        if (v.getId() == R.id.note_touch_target) {
            this.presenter.closeWindow((Activity)this);
            this.metricTracker.closedInAppFromFull(this.conversationId, this.part.getId());
            this.startActivity(IntercomMessengerActivity.openConversation((Context)this, this.conversationId, this.lastParticipatingAdmin));
        }
    }
}

