/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.support.annotation.DimenRes;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.profile.TeamProfilePresenter;
import io.intercom.android.sdk.profile.TeammateProfilePresenter;

public class ProfileCoordinator {
    final AppBarLayout appBarLayout;
    private final View toolbar;
    private String conversationId = "";
    private final CoordinatorLayout coordinatorLayout;
    private final ViewGroup titleLayoutCoordinator;
    private AppBarLayout.OnOffsetChangedListener offsetListener = null;
    State currentState = State.IDLE;
    boolean isAnimating = false;
    private boolean didShowUnknown = false;
    private boolean wasClicked = false;
    private boolean autoOpened = false;
    private final TeammateProfilePresenter teammateProfilePresenter;
    private final TeamProfilePresenter teamProfilePresenter;
    private final MetricFactory metricFactory;
    private final MetricsStore metricStore;

    public ProfileCoordinator(CoordinatorLayout rootView, MetricsStore metricsStore, MetricFactory metricFactory) {
        int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
        this.coordinatorLayout = (CoordinatorLayout)rootView.findViewById(R.id.conversation_coordinator_layout);
        this.appBarLayout = (AppBarLayout)rootView.findViewById(R.id.app_bar_layout);
        this.toolbar = rootView.findViewById(R.id.profile_toolbar);
        this.titleLayoutCoordinator = (FrameLayout)rootView.findViewById(R.id.profile_toolbar_coordinator);
        this.teammateProfilePresenter = new TeammateProfilePresenter(rootView, baseColor, this);
        this.teamProfilePresenter = new TeamProfilePresenter(rootView, baseColor, this);
        this.metricStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    public void setUnknownPresence() {
        this.didShowUnknown = true;
        this.teammateProfilePresenter.getRootLayout().setAlpha(0.0f);
        this.teamProfilePresenter.getRootLayout().setAlpha(0.0f);
        this.toolbar.setBackgroundColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teamProfilePresenter.getToolbarBehavior());
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teammateProfilePresenter.getToolbarBehavior());
    }

    public void setTeamPresence(TeamPresence teamPresence, int maxWidth) {
        this.toolbar.setBackgroundColor(0);
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teammateProfilePresenter.getToolbarBehavior());
        this.teamProfilePresenter.setPresence(teamPresence, maxWidth, this.appBarLayout, (View)this.teammateProfilePresenter.getRootLayout(), (View)this.titleLayoutCoordinator);
    }

    public void setTeamCollapsingTitle(@Nullable CharSequence title) {
        this.teamProfilePresenter.setTeamCollapsingTitle(title);
    }

    public void setTeammatePresence(LastParticipatingAdmin lastParticipant, CharSequence lastActiveTime, boolean active, int maxWidth) {
        this.toolbar.setBackgroundColor(0);
        this.appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.teamProfilePresenter.getToolbarBehavior());
        this.teammateProfilePresenter.setPresence(lastParticipant, lastActiveTime, active, maxWidth, this.appBarLayout, this.currentState, (View)this.teamProfilePresenter.getRootLayout(), (View)this.titleLayoutCoordinator);
    }

    public void hideTeammateSubtitle() {
        this.teammateProfilePresenter.setTeammateSubtitle(null);
    }

    public void applyOffsetChangedListener(final AppBarLayout.OnOffsetChangedListener behavior) {
        this.appBarLayout.addOnOffsetChangedListener(behavior);
        this.appBarLayout.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ProfileCoordinator.this.appBarLayout.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                behavior.onOffsetChanged(ProfileCoordinator.this.appBarLayout, 0);
                return false;
            }
        });
    }

    public void startOffsetListener() {
        if (this.offsetListener == null) {
            this.offsetListener = new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
                    if (verticalOffset == 0) {
                        if (ProfileCoordinator.this.currentState != State.EXPANDED) {
                            ProfileCoordinator.this.trackOpenMetric();
                            InputMethodManager inputMethodManager = (InputMethodManager)appBarLayout.getContext().getSystemService("input_method");
                            inputMethodManager.hideSoftInputFromWindow(appBarLayout.getWindowToken(), 0);
                        }
                        ProfileCoordinator.this.isAnimating = false;
                        ProfileCoordinator.this.currentState = State.EXPANDED;
                    } else if (Math.abs(verticalOffset) >= appBarLayout.getTotalScrollRange()) {
                        ProfileCoordinator.this.isAnimating = false;
                        ProfileCoordinator.this.currentState = State.COLLAPSED;
                    } else {
                        ProfileCoordinator.this.currentState = State.IDLE;
                    }
                }
            };
            this.appBarLayout.addOnOffsetChangedListener(this.offsetListener);
        }
    }

    public void addListener(AppBarLayout.OnOffsetChangedListener listener) {
        this.appBarLayout.addOnOffsetChangedListener(listener);
    }

    public boolean isExpanded() {
        return this.currentState == State.EXPANDED;
    }

    void trackOpenMetric() {
        ProfileType profileType;
        ProfileType profileType2 = profileType = this.teamProfilePresenter.getRootLayout().getAlpha() == 0.0f ? ProfileType.TEAMMATE : ProfileType.TEAM;
        if (this.wasClicked) {
            this.metricStore.track(this.metricFactory.profileClickedOpen(this.conversationId, profileType));
        } else if (this.autoOpened) {
            this.metricStore.track(this.metricFactory.profileAutoOpen(this.conversationId, profileType));
        } else {
            this.metricStore.track(this.metricFactory.profileScrolledOpen(this.conversationId, profileType));
        }
        this.wasClicked = false;
        this.autoOpened = false;
    }

    public void profileAutoOpened() {
        this.autoOpened = true;
        this.flingProfileOpen();
    }

    public void profileClicked() {
        this.wasClicked = true;
        this.flingProfileOpen();
    }

    private void flingProfileOpen() {
        this.flingProfile(R.dimen.intercom_open_velocity);
    }

    public void flingProfileClosed() {
        this.flingProfile(R.dimen.intercom_close_velocity);
    }

    private void flingProfile(@DimenRes int yVelocityRes) {
        if (this.isAnimating) {
            return;
        }
        CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)this.appBarLayout.getLayoutParams();
        AppBarLayout.Behavior behavior = (AppBarLayout.Behavior)params.getBehavior();
        if (behavior != null) {
            int velocity = this.appBarLayout.getResources().getDimensionPixelSize(yVelocityRes);
            behavior.onNestedFling(this.coordinatorLayout, this.appBarLayout, null, 0.0f, (float)velocity, false);
        }
        this.isAnimating = true;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public boolean isDidShowUnknown() {
        return this.didShowUnknown;
    }

    public void setDidShowUnknown(boolean didShowUnknown) {
        this.didShowUnknown = didShowUnknown;
    }

    public void onStop() {
        this.teammateProfilePresenter.stopUpdatingTime();
    }

    public static enum State {
        COLLAPSED,
        EXPANDED,
        IDLE;

    }

    public static enum ProfileType {
        TEAMMATE,
        TEAM;

    }
}

