/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.LinkResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.LinkEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.LinkFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.state.ReplyPart;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;

class CallbackHolder {
    final Bus bus;
    final Store<State> store;
    private final UserIdentity userIdentity;
    private final AppIdentity appIdentity;
    private final Twig twig = LumberMill.getLogger();

    CallbackHolder(Bus bus, Store<State> store, UserIdentity userIdentity, AppIdentity appIdentity) {
        this.bus = bus;
        this.store = store;
        this.userIdentity = userIdentity;
        this.appIdentity = appIdentity;
    }

    BaseCallback<ReadResponse.Builder> readCallback() {
        return new BaseCallback<ReadResponse.Builder>(){

            @Override
            public void onSuccess(ReadResponse.Builder builder) {
                CallbackHolder.this.updateBaseResponseObjects(builder.build());
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder responseBuilder) {
                UsersResponse response = responseBuilder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
            }
        };
    }

    BaseCallback<UpdateUserResponse.Builder> teamPresenceCallback() {
        return new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            void onSuccess(UpdateUserResponse.Builder builder) {
                TeamPresence teamPresence = builder.build().getTeamPresence();
                CallbackHolder.this.store.dispatch(Actions.teamPresenceUpdated(teamPresence));
            }
        };
    }

    Callback<ConversationsResponse.Builder> inboxCallback() {
        return new BaseCallback<ConversationsResponse.Builder>(){

            @Override
            public void onSuccess(ConversationsResponse.Builder builder) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.updateBaseResponseObjects(response);
                CallbackHolder.this.store.dispatch(Actions.fetchInboxSuccess(response));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.store.dispatch(Actions.fetchInboxFailed());
            }
        };
    }

    Callback<Part.Builder> replyCallback(final int position, final boolean isUpload, final String partId, final String conversationId) {
        return new BaseCallback<Part.Builder>(){

            @Override
            public void onSuccess(Part.Builder builder) {
                Part response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.conversationReplySuccess(new ReplyPart(response, conversationId)));
                CallbackHolder.this.bus.post((Object)new ReplyEvent(response, position, partId, conversationId));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ReplyFailedEvent(position, isUpload, partId));
            }
        };
    }

    Callback<Conversation.Builder> conversationCallback() {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.fetchConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new ConversationEvent(conversation));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ConversationFailedEvent());
            }
        };
    }

    Callback<Conversation.Builder> newConversationCallback(final int position, final String partId) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.newConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new NewConversationEvent(conversation, partId));
            }

            @Override
            void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    Callback<Void> reactCallback() {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                CallbackHolder.this.twig.internal("Reaction success");
            }

            public void onFailure(Call<Void> call, Throwable t) {
                CallbackHolder.this.twig.e("Failed to update reaction", new Object[0]);
            }
        };
    }

    Callback<LinkResponse.Builder> linkCallback() {
        return new BaseCallback<LinkResponse.Builder>(){

            @Override
            public void onSuccess(LinkResponse.Builder builder) {
                LinkResponse linkResponse = builder.build();
                CallbackHolder.this.bus.post((Object)new LinkEvent(linkResponse.getLink()));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new LinkFailedEvent());
            }
        };
    }

    void updateBaseResponseObjects(BaseResponse response) {
        this.store.dispatch(Actions.baseResponseReceived(response));
        this.userIdentity.update(response.getUser());
        this.appIdentity.updateAppConfig(response.getConfig(), this.bus);
    }
}

