/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.blockInterfaces.ImageBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.lightbox.LightBoxActivity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.LinkOpener;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.util.Util;

class NetworkImage
extends Image
implements ImageBlock {
    private static final int PROGRESSBAR_DIAMETER_DP = 40;
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;
    private final UploadingImageCache uploadingImageCache;

    NetworkImage(Context context, StyleType style, Api.Provider apiProvider, AppConfig.Provider appConfigProvider, UploadingImageCache uploadingImageCache) {
        super(context, style);
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
        this.uploadingImageCache = uploadingImageCache;
    }

    @VisibleForTesting
    void onImageClicked(Context context, String imageUrl, String linkUrl, ImageView imageView, int width, int height) {
        if (!TextUtils.isEmpty((CharSequence)linkUrl)) {
            LinkOpener.handleUrl(linkUrl, context, this.apiProvider.getApi());
            return;
        }
        if (context instanceof Activity) {
            Activity rootActivity = (Activity)context;
            WindowManager.LayoutParams windowAttributes = rootActivity.getWindow().getAttributes();
            boolean fullScreen = (windowAttributes.flags & 0x400) != 0;
            Intent intent = LightBoxActivity.imageIntent((Context)rootActivity, imageUrl, fullScreen, width, height);
            if (Build.VERSION.SDK_INT >= 16) {
                ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)rootActivity, (View)imageView, (String)"lightbox_image");
                rootActivity.startActivity(intent, options.toBundle());
            } else {
                rootActivity.startActivity(intent);
            }
        } else {
            context.startActivity(LightBoxActivity.imageIntent(context, imageUrl, false, width, height));
        }
    }

    public View addImage(final String url, final String linkUrl, final int width, final int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        int scaledWidth = ScreenUtils.convertDpToPixel((float)width, (Context)this.getContext());
        int scaledHeight = ScreenUtils.convertDpToPixel((float)height, (Context)this.getContext());
        FrameLayout rootView = new FrameLayout(this.getContext());
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        final ResizableImageView imageView = new ResizableImageView(this.getContext());
        if (Build.VERSION.SDK_INT >= 21) {
            imageView.setTransitionName("lightbox_image");
        }
        BlockUtils.createLayoutParams((View)imageView, -2, -2);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground(imageView);
        Resources resources = this.getContext().getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int baseColor = this.appConfigProvider.getAppConfig().getBaseColor();
        final ProgressBar spinner = new ProgressBar(this.getContext());
        int spinnerDiameterPx = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics);
        spinner.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(spinnerDiameterPx, spinnerDiameterPx, 17));
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.intercom_progress_wheel);
        drawable2.setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        spinner.setIndeterminateDrawable(drawable2);
        spinner.setIndeterminate(true);
        rootView.addView((View)imageView);
        rootView.addView((View)spinner);
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.hideLoadingState(spinner, imageView);
            imageView.setImageResource(R.drawable.intercom_error);
        } else {
            DrawableTypeRequest requestCreator = Glide.with((Context)this.getContext()).load(url);
            this.setImageViewBounds(scaledWidth, scaledHeight, imageView, requestCreator);
            String localImagePath = this.uploadingImageCache.getLocalImagePathForRemoteUrl(url);
            if (!TextUtils.isEmpty((CharSequence)localImagePath)) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = this.getSampleSize(scaledWidth, scaledHeight, displayMetrics);
                Bitmap bitmap = BitmapFactory.decodeFile((String)localImagePath, (BitmapFactory.Options)options);
                BitmapDrawable localImage = new BitmapDrawable(resources, bitmap);
                localImage.setColorFilter(ColorUtils.newGreyscaleFilter());
                requestCreator.placeholder((Drawable)localImage).dontAnimate();
            }
            requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(this.getContext(), resources.getDimensionPixelSize(R.dimen.intercomsdk_image_rounded_corners))}).error(R.drawable.intercom_error).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

                public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    IntercomLogger.internal("images", "FAILURE");
                    return false;
                }

                public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                    IntercomLogger.internal("images", "SUCCESS");
                    NetworkImage.this.hideLoadingState(spinner, imageView);
                    if (NetworkImage.this.getStyle() != StyleType.CHAT_FULL) {
                        imageView.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                InputMethodManager imm = (InputMethodManager)NetworkImage.this.getContext().getSystemService("input_method");
                                imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                                NetworkImage.this.onImageClicked(NetworkImage.this.getContext(), url, linkUrl, imageView, width, height);
                            }
                        });
                    }
                    return false;
                }
            }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url));
            if (Util.isValidDimensions((int)width, (int)height)) {
                requestCreator.override(width, height);
            }
            requestCreator.into((ImageView)imageView);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }

    @VisibleForTesting
    int getSampleSize(int scaledWidth, int scaledHeight, DisplayMetrics displayMetrics) {
        int sampleSize = 1;
        if (scaledWidth > displayMetrics.widthPixels || scaledHeight > displayMetrics.heightPixels) {
            sampleSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log((double)displayMetrics.widthPixels / (double)Math.max(scaledHeight, scaledWidth)) / Math.log(0.5)));
        }
        return sampleSize;
    }

    private void hideLoadingState(ProgressBar spinner, ImageView imageView) {
        if (spinner != null) {
            spinner.setVisibility(8);
            imageView.setBackgroundResource(17170445);
        }
    }
}

