/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.profile.ProfileCoordinator;
import io.intercom.android.sdk.utilities.TimeProvider;

public class MetricFactory {
    static final String ACTION_OPENED = "opened";
    static final String ACTION_CLOSED = "closed";
    static final String ACTION_TYPED = "typed";
    static final String ACTION_SENT = "sent";
    static final String ACTION_RECEIVED = "received";
    static final String ACTION_VIEWED = "viewed";
    static final String ACTION_DISMISSED = "dismissed";
    static final String OBJECT_CONVERSATION_LIST = "conversation_list";
    static final String OBJECT_CONVERSATION = "conversation";
    static final String OBJECT_NEW_CONVERSATION = "new_conversation";
    static final String OBJECT_MESSENGER = "messenger";
    static final String OBJECT_MESSAGE = "message";
    static final String OBJECT_BADGE = "badge";
    static final String OBJECT_REPLY = "reply";
    static final String OBJECT_REACTION = "reaction";
    static final String OBJECT_TEAMMATE_PROFILE = "teammate_profile";
    static final String OBJECT_TEAM_PROFILE = "team_profile";
    static final String PLACE_MESSENGER = "messenger";
    static final String PLACE_IN_APP = "in_app";
    static final String PLACE_PUSH = "push";
    static final String CONTEXT_FROM_LAUNCHER = "from_launcher";
    static final String CONTEXT_FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
    static final String CONTEXT_FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
    static final String CONTEXT_FROM_CLOSE_BUTTON = "from_close_button";
    static final String CONTEXT_FROM_CONVERSATION_LIST = "from_conversation_list";
    static final String CONTEXT_IN_NEW_CONVERSATION = "in_new_conversation";
    static final String CONTEXT_FROM_NEW_CONVERSATION = "from_new_conversation";
    static final String CONTEXT_FROM_CONVERSATION = "from_conversation";
    static final String CONTEXT_IN_CONVERSATION = "in_conversation";
    static final String CONTEXT_FROM_SNIPPET = "from_snippet";
    static final String CONTEXT_FROM_FULL = "from_full";
    static final String CONTEXT_FROM_CLICKING = "from_clicking";
    static final String CONTEXT_FROM_SCROLLING = "from_scrolling";
    static final String CONTEXT_FROM_AUTO = "from_auto";
    static final String CONTEXT_FROM_PUSH = "from_push";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";

    public static MetricObject openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", fromContext);
    }

    public static MetricObject openedMessengerConversation(String conversationId, LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION, "messenger", fromContext).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        String fromContext = LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? CONTEXT_FROM_LAUNCHER : CONTEXT_FROM_CUSTOM_LAUNCHER;
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", fromContext);
    }

    public static MetricObject closedMessengerBackButton() {
        return MetricFactory.constructMetricObject(ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_ANDROID_BACK_BUTTON);
    }

    public static MetricObject closedMessengerCloseButton() {
        return MetricFactory.constructMetricObject(ACTION_CLOSED, "messenger", "messenger", CONTEXT_FROM_CLOSE_BUTTON);
    }

    public static MetricObject newConversationFromComposeButton() {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_NEW_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST);
    }

    static MetricObject typeInNewConversation() {
        return MetricFactory.constructMetricObject(ACTION_TYPED, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION);
    }

    static MetricObject typeInConversation(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_TYPED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject sentInNewConversation(boolean isAttachment, String partId, String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_SENT, "message", "messenger", CONTEXT_IN_NEW_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject sentInConversation(boolean isAttachment, String partId, String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_SENT, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openConversationsListFromNewConversation() {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_NEW_CONVERSATION);
    }

    public static MetricObject startConversation(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_NEW_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openConversationsListFromConversation(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION_LIST, "messenger", CONTEXT_FROM_CONVERSATION).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openedConversationFromFull(String conversationId, String commentId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openedConversationFromSnippet(String conversationId, String commentId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_SNIPPET).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject receivedReply(boolean isAttachment, String partId, String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, OBJECT_REPLY, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject sentReaction(String conversationId, String messageId, ReactionInputView.ReactionLocation reactionLocation) {
        if (ReactionInputView.ReactionLocation.CONVERSATION == reactionLocation) {
            return MetricFactory.constructMetricObject(ACTION_SENT, OBJECT_REACTION, "messenger", CONTEXT_IN_CONVERSATION).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
        }
        return MetricFactory.constructMetricObject(ACTION_SENT, OBJECT_REACTION, PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject profileClickedOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return MetricFactory.constructMetricObject(ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_CLICKING).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject profileAutoOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return MetricFactory.constructMetricObject(ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_AUTO).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject profileScrolledOpen(String conversationId, ProfileCoordinator.ProfileType profileType) {
        String profileObject = ProfileCoordinator.ProfileType.TEAMMATE == profileType ? OBJECT_TEAMMATE_PROFILE : OBJECT_TEAM_PROFILE;
        return MetricFactory.constructMetricObject(ACTION_OPENED, profileObject, "messenger", CONTEXT_FROM_SCROLLING).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject openConversationFromConversationList(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, OBJECT_CONVERSATION, "messenger", CONTEXT_FROM_CONVERSATION_LIST).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject receivedPushNotification(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION);
    }

    public static MetricObject receivedPushOnlyNotification(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, "message", PLACE_PUSH, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message");
    }

    public static MetricObject viewedPushNotification(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION);
    }

    public static MetricObject openedPushOnlyNotification(String conversationId) {
        return MetricFactory.constructMetricObject(ACTION_OPENED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, "message");
    }

    public static MetricObject dismissedPushNotification(String conversationId, boolean isPushOnly) {
        String pushType = isPushOnly ? "message" : VALUE_NOTIFICATION;
        return MetricFactory.constructMetricObject(ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_PUSH).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_PUSH_TYPE, pushType);
    }

    public static MetricObject receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, OBJECT_BADGE, PLACE_IN_APP, CONTEXT_FROM_LAUNCHER).addMetaData(METADATA_BADGE_VALUE, badgeValue);
    }

    public static MetricObject receivedMessageFromSnippetWhenClosed(String conversationId, String messageId, String messageStyle) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle);
    }

    public static MetricObject receivedReplyFromSnippetWhenClosed(String conversationId, String commentId) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId);
    }

    public static MetricObject receivedMessageFromFullWhenClosed(String conversationId, String messageId, String messageStyle) {
        return MetricFactory.constructMetricObject(ACTION_RECEIVED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle);
    }

    public static MetricObject dismissInAppMessageSnippet(String conversationId, String messageId) {
        return MetricFactory.constructMetricObject(ACTION_DISMISSED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_MESSAGE_ID, messageId);
    }

    public static MetricObject dismissInAppCommentSnippet(String conversationId, String commentId) {
        return MetricFactory.constructMetricObject(ACTION_DISMISSED, OBJECT_REPLY, PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_CONVERSATION_ID, conversationId).addMetaData(METADATA_COMMENT_ID, commentId);
    }

    public static MetricObject viewedInAppFromFull(String conversationId, String messageId) {
        return MetricFactory.constructMetricObject(ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject viewedInAppFromMessenger(String conversationId, String messageId) {
        return MetricFactory.constructMetricObject(ACTION_VIEWED, "message", "messenger", CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject viewedInAppFromSnippet(String conversationId, String messageId) {
        return MetricFactory.constructMetricObject(ACTION_VIEWED, "message", PLACE_IN_APP, CONTEXT_FROM_SNIPPET).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    public static MetricObject closedInAppFromFull(String conversationId, String messageId) {
        return MetricFactory.constructMetricObject(ACTION_CLOSED, "message", PLACE_IN_APP, CONTEXT_FROM_FULL).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId);
    }

    private static MetricObject constructMetricObject(String action, String object, String place, String context) {
        return new MetricObject(Injector.get().getUserIdentity().getIntercomId(), action, object, place, context, TimeProvider.SYSTEM);
    }
}

