/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.FloatingActionButton;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EdgeEffect;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.fragments.IntercomSupportFragment;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.ConversationsHolder;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationList;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.InboxEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.InboxFailedEvent;
import io.intercom.android.sdk.models.events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.store.LastViewStore;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.squareup.otto.Subscribe;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ConversationsListFragment
extends IntercomSupportFragment
implements View.OnClickListener,
ConversationClickListener,
EndlessScrollListener,
IntercomToolbar.Listener {
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    protected ConversationsHolder conversationsHolder;
    private IntercomToolbar intercomToolbar;
    private View rootView;
    @VisibleForTesting
    RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private View loadingView;
    private FloatingActionButton floatingActionButton;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    private Listener listener;
    private InboxAdapter adapter;
    private String openConversationId = "";
    private boolean loading;
    private boolean isTwoPane = false;
    private boolean shouldOpenFirstConversation = false;

    public static ConversationsListFragment newInstance(boolean isTwoPane) {
        ConversationsListFragment conversationListFragment = new ConversationsListFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        conversationListFragment.setArguments(args);
        return conversationListFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.init(this.getActivity().getApplication());
        this.loading = true;
        this.conversationsHolder = new ConversationsHolder();
        this.adapter = new InboxAdapter((Context)this.getActivity(), this.conversationsHolder, this, Injector.get().getTeamPresenceProvider());
        this.layoutManager = new LinearLayoutManager((Context)this.getActivity());
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        Injector.get().getBus().register((Object)this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        IntercomLogger.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
            this.loadingView = this.rootView.findViewById(R.id.progressBar);
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_inbox);
            this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
            this.floatingActionButton = (FloatingActionButton)this.rootView.findViewById(R.id.compose_action_button);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progressBar);
            this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
            this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.floatingActionButton.setOnClickListener((View.OnClickListener)this);
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ConversationsListFragment.this.displayLoadingView();
                    ConversationsListFragment.this.fetchNewConversations();
                }
            });
            this.displayLoadingView();
            this.fetchNewConversations();
            this.intercomToolbar.setListener(this);
            this.intercomToolbar.setSubtitleVisibility(8);
            this.setToolbarColor();
            this.setToolbarTitle();
            if (this.isTwoPane) {
                this.intercomToolbar.setCloseButtonVisibility(8);
            }
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
        }
        this.setColorScheme();
        this.openConversationId = "";
        this.decideInboundCapability();
        this.adapter.notifyDataSetChanged();
        return this.rootView;
    }

    public void onResume() {
        Injector.get().getLastViewStore().setLastState(LastViewStore.State.INBOX);
        if (!this.isTwoPane) {
            this.inboxView.setAlpha(1.0f);
            this.setToolbarTitle();
        }
        if (!this.loading) {
            if (this.conversationsHolder.isEmpty()) {
                this.displayEmptyView();
            } else {
                this.displayInbox();
            }
        }
        super.onResume();
    }

    public void onDestroy() {
        Injector.get().getBus().unregister((Object)this);
        super.onDestroy();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compose_action_button) {
            if (this.isTwoPane) {
                this.displayComposerView();
            } else {
                this.fadeOutInbox(new SimpleAnimatorListener(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        ConversationsListFragment.this.displayComposerView();
                    }
                });
            }
            Injector.get().getMetricsStore().track(MetricFactory.newConversationFromComposeButton());
        }
    }

    @Override
    public void onConversationClicked(int position) {
        final Conversation conversation = (Conversation)this.conversationsHolder.get(position);
        this.openConversationId = conversation.getId();
        if (this.isTwoPane) {
            this.displayConversationView(conversation);
        } else {
            this.fadeOutInbox(new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    ConversationsListFragment.this.displayConversationView(conversation);
                }
            });
        }
        Injector.get().getMetricsStore().track(MetricFactory.openConversationFromConversationList(conversation.getId()));
    }

    @Override
    public void onSupportAttach(Context context) {
        super.onSupportAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationsListFragment.Listener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void setShouldOpenFirstConversation(boolean shouldOpenFirstConversation) {
        this.shouldOpenFirstConversation = shouldOpenFirstConversation;
    }

    private void displayConversationView(Conversation conversation) {
        LastParticipatingAdmin lastParticipatingAdmin = conversation.getLastParticipatingAdmin();
        if (LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            lastParticipatingAdmin = LastParticipatingAdmin.NONE;
        }
        this.listener.loadConversation(conversation.getId(), lastParticipatingAdmin, conversation.getRead(), !this.isTwoPane);
    }

    private void displayComposerView() {
        this.listener.loadConversation("", LastParticipatingAdmin.NONE, true, !this.isTwoPane);
    }

    private void fadeOutInbox(SimpleAnimatorListener endListener) {
        this.intercomToolbar.fadeOutInbox();
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.inboxView, (Property)View.ALPHA, (float[])new float[]{this.inboxView.getAlpha(), 0.0f}).setDuration(150L);
        animator2.addListener((Animator.AnimatorListener)endListener);
        animator2.start();
    }

    private void decideInboundCapability() {
        this.floatingActionButton.setVisibility(this.isInboundMessageEnabled() ? 0 : 8);
    }

    private boolean isInboundMessageEnabled() {
        return Injector.get().getAppIdentity().getAppConfig().isInboundMessages();
    }

    private void displayInbox() {
        if (this.isAdded()) {
            this.inboxView.setVisibility(0);
            this.floatingActionButton.setVisibility(0);
            this.inboxErrorView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayError() {
        if (this.isAdded()) {
            this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
            this.inboxErrorView.setSubtitle(R.string.intercom_conversation_error_state_subtitle);
            this.inboxErrorView.setActionButtonText(R.string.intercom_tap_to_retry);
            this.inboxErrorView.setActionButtonVisibility(0);
            this.inboxErrorView.setVisibility(0);
            this.inboxView.setVisibility(8);
            this.loadingView.setVisibility(8);
            this.floatingActionButton.setVisibility(8);
        }
    }

    private void displayEmptyView() {
        if (this.isAdded()) {
            this.inboxErrorView.setTitle(R.string.intercom_no_messages);
            CharSequence subtitle = Phrase.from(this.getContext(), R.string.intercom_empty_conversations).put("name", Injector.get().getAppIdentity().getAppConfig().getName()).format();
            this.inboxErrorView.setSubtitle(subtitle);
            this.inboxErrorView.setActionButtonVisibility(8);
            this.inboxErrorView.setVisibility(0);
            this.floatingActionButton.setVisibility(0);
            this.inboxView.setVisibility(8);
            this.loadingView.setVisibility(8);
        }
    }

    private void displayLoadingView() {
        if (this.isAdded()) {
            this.inboxErrorView.setVisibility(8);
            this.inboxView.setVisibility(8);
            this.floatingActionButton.setVisibility(8);
            this.loadingView.setVisibility(0);
        }
    }

    private void addLoadingCell() {
        Conversation.Loading loadingCell = new Conversation.Loading();
        this.conversationsHolder.add(loadingCell);
        this.adapter.notifyItemInserted(this.conversationsHolder.size() - 1);
    }

    private void removeLoadingCell() {
        int numConversations = this.conversationsHolder.size();
        if (numConversations > 0 && this.conversationsHolder.get(numConversations - 1) instanceof Conversation.Loading) {
            this.conversationsHolder.remove(numConversations - 1);
            this.adapter.notifyItemRemoved(numConversations - 1);
        }
    }

    private void fetchNewConversations() {
        Injector.get().getApi().getInbox();
    }

    private void realtimeUpdate() {
        this.fetchNewConversations();
    }

    @Subscribe
    public void inboxSuccess(InboxEvent event) {
        ConversationList list = event.getResponse();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(list.hasMorePages());
        this.removeLoadingCell();
        this.conversationsHolder.syncInbox(list.getConversations(), this.adapter, this.layoutManager);
        this.loading = false;
        if (this.isAdded()) {
            this.setColorScheme();
            if (list.getConversations().isEmpty() && this.conversationsHolder.isEmpty()) {
                this.displayEmptyView();
                if (this.isTwoPane && this.shouldOpenFirstConversation && this.isInboundMessageEnabled()) {
                    this.displayComposerView();
                    this.shouldOpenFirstConversation = false;
                }
            } else {
                this.displayInbox();
                if (this.isTwoPane && this.shouldOpenFirstConversation) {
                    this.displayConversationView(list.getConversations().get(0));
                    this.shouldOpenFirstConversation = false;
                }
            }
            this.decideInboundCapability();
        }
    }

    private void setColorScheme() {
        int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
        this.progressBar.getIndeterminateDrawable().setColorFilter(baseColor, PorterDuff.Mode.SRC_IN);
        this.floatingActionButton.setBackgroundTintList(ColorStateList.valueOf((int)baseColor));
        this.listener.setStatusBarColor();
        this.setToolbarColor();
    }

    @Subscribe
    public void inboxFailedToLoad(InboxFailedEvent event) {
        if (this.isAdded()) {
            this.displayError();
        }
    }

    @Subscribe
    public void newComment(NewCommentEvent event) {
        if (!event.getConversationId().equals(this.openConversationId)) {
            this.realtimeUpdate();
        }
    }

    @Subscribe
    public void newConversation(CreateConversationEvent event) {
        this.realtimeUpdate();
    }

    @Subscribe
    public void markedAsRead(ReadEvent event) {
        for (Conversation conversation : this.conversationsHolder) {
            if (!conversation.getId().equals(event.getConversationId()) || conversation.getRead().booleanValue()) continue;
            conversation.setRead(true);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void newConversationEvent(NewConversationEvent event) {
        Conversation newConversation = event.getResponse();
        this.openConversationId = newConversation.getId();
        if (!this.conversationsHolder.contains(newConversation)) {
            this.conversationsHolder.add(0, newConversation);
            this.conditionallyNotifyDataSetChanged();
            if (this.inboxView.getVisibility() == 8) {
                this.displayInbox();
            }
        }
    }

    @Subscribe
    public void conversationRefresh(ConversationEvent event) {
        Conversation newConversation = event.getResponse();
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            Conversation conversation = (Conversation)this.conversationsHolder.get(i);
            if (!conversation.getId().equals(newConversation.getId())) continue;
            this.conversationsHolder.remove(i);
            this.conversationsHolder.add(i, newConversation);
            if (!newConversation.getRead().booleanValue() && conversation.getRead().booleanValue() && !newConversation.getId().equals(this.openConversationId)) {
                Injector.get().getUnreadCountTracker().addConversationId(this.openConversationId);
            }
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    @Subscribe
    public void replyInConversation(ReplyEvent event) {
        for (int i = 0; i < this.conversationsHolder.size(); ++i) {
            if (!((Conversation)this.conversationsHolder.get(i)).getId().equals(event.getConversationId())) continue;
            Conversation conversation = (Conversation)this.conversationsHolder.remove(i);
            conversation.getParts().add(event.getResponse());
            this.conversationsHolder.add(0, conversation);
            this.conditionallyNotifyDataSetChanged();
            break;
        }
    }

    private void conditionallyNotifyDataSetChanged() {
        if (this.isAdded()) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onLoadMore() {
        if (!this.loading) {
            this.loading = true;
            Conversation conversation = this.conversationsHolder.getLastConversation();
            if (conversation != null) {
                Injector.get().getApi().getInboxBefore(conversation.getLastPart().getCreatedAt());
                this.addLoadingCell();
            }
        }
    }

    @Override
    public void setOverScrollColour() {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Class<RecyclerView> clazz = RecyclerView.class;
                for (String name : new String[]{"ensureTopGlow", "ensureBottomGlow"}) {
                    Method method = clazz.getDeclaredMethod(name, new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)this.inboxView, new Object[0]);
                }
                for (String name : new String[]{"mTopGlow", "mBottomGlow"}) {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    Object edge = field.get(this.inboxView);
                    Field edgeEffect = edge.getClass().getDeclaredField("mEdgeEffect");
                    edgeEffect.setAccessible(true);
                    int baseColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
                    ((EdgeEffect)edgeEffect.get(edge)).setColor(baseColor);
                }
            }
            catch (Exception ignored) {
                IntercomLogger.d("Could not set overscroll colour");
            }
        }
    }

    private void setToolbarTitle() {
        String appName = Injector.get().getAppIdentity().getAppConfig().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_chats));
        } else {
            CharSequence title = Phrase.from(this.getContext(), R.string.intercom_chats_with).put("name", appName).format();
            this.intercomToolbar.setTitle(title);
        }
    }

    private void setToolbarColor() {
        this.intercomToolbar.setBackgroundColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onInboxClicked() {
    }

    public static interface Listener {
        public void loadConversation(String var1, LastParticipatingAdmin var2, boolean var3, boolean var4);

        public void setStatusBarColor();

        public void onToolbarCloseClicked();
    }
}

