/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.utilities.IntentUtils;

@SuppressLint(value={"ViewConstructor"})
public class AttachmentView
extends LinearLayout
implements View.OnClickListener {
    static final int ATTACHMENT_ICON_WIDTH_SP = 20;
    static final int DIVIDER_MARGIN_SP = 6;
    static final int DIVIDER_WIDTH_SP = 1;
    private final String url;

    public AttachmentView(Context context, DisplayMetrics metrics, StyleType style, int baseColour, BlockAttachment attachment) {
        super(context);
        this.url = attachment.getUrl();
        this.setOrientation(0);
        ImageView attachmentIcon = this.setupIcon(context, metrics, style, baseColour);
        this.addView((View)attachmentIcon);
        if (this.isUserMessage(style)) {
            View divider = this.setupDivider(context, metrics);
            this.addView(divider);
        }
        TextView attachmentName = this.setupName(context, style, baseColour, attachment.getName());
        this.addView((View)attachmentName);
    }

    private ImageView setupIcon(Context context, DisplayMetrics metrics, StyleType style, int baseColour) {
        ImageView divider = new ImageView(context);
        int width = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)metrics);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -2);
        params.gravity = 19;
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setImageResource(R.drawable.intercomsdk_attachment);
        if (!this.isUserMessage(style)) {
            divider.setColorFilter(baseColour);
        }
        return divider;
    }

    private View setupDivider(Context context, DisplayMetrics metrics) {
        View divider = new View(context);
        int width = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)metrics);
        int margin = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -1);
        params.setMargins(margin, 0, margin, 0);
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        return divider;
    }

    private TextView setupName(Context context, StyleType style, int baseColour, String name) {
        TextView divider = new TextView(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.gravity = 19;
        divider.setLayoutParams((ViewGroup.LayoutParams)params);
        divider.setEllipsize(TextUtils.TruncateAt.END);
        divider.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_full_transparent_full_black));
        divider.setGravity(19);
        divider.setTextSize(2, 15.0f);
        divider.setText((CharSequence)name);
        divider.setOnClickListener((View.OnClickListener)this);
        if (this.isUserMessage(style)) {
            divider.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_white));
        } else {
            divider.setTextColor(baseColour);
        }
        return divider;
    }

    public void onClick(View v) {
        Uri uri = Uri.parse((String)this.url);
        if (!Uri.EMPTY.equals((Object)uri)) {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.setFlags(0x10000000);
            IntentUtils.safelyOpenIntent(this.getContext(), intent);
        }
    }

    private boolean isUserMessage(StyleType style) {
        return StyleType.PREVIEW == style || StyleType.USER == style;
    }
}

