/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.attachments;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.attachments.AttachmentPresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.views.AttachedImageView;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import java.io.File;

public class AttachmentActivity
extends IntercomBaseActivity
implements View.OnClickListener {
    private final Twig twig = LumberMill.getLogger();
    private ImageView attachmentIcon;
    private TextView attachmentDetails;
    private TextView attachmentSize;
    private Button sendButton;
    AttachedImageView previewImage;
    ProgressBar spinner;
    AttachmentPresenter presenter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_attachment);
        this.spinner = (ProgressBar)this.findViewById(R.id.loading_wheel);
        this.sendButton = (Button)this.findViewById(R.id.send_button);
        this.previewImage = (AttachedImageView)this.findViewById(R.id.image_preview);
        this.attachmentIcon = (ImageView)this.findViewById(R.id.attachment_icon);
        this.attachmentDetails = (TextView)this.findViewById(R.id.attachment_details);
        this.attachmentSize = (TextView)this.findViewById(R.id.attachment_size);
        AppConfig appConfig = Injector.get().getAppIdentity().getAppConfig();
        this.spinner.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
        this.sendButton.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cancel_button).setOnClickListener((View.OnClickListener)this);
        this.presenter = new AttachmentPresenter(this);
        this.previewImage.setOnAttachedToWindowListener(new AttachedImageView.OnAttachedToWindowListener(){

            @Override
            public void callback() {
                AttachmentActivity.this.presenter.loadFile(AttachmentActivity.this.getIntent().getData(), AttachmentActivity.this.previewImage.isHardwareAccelerated());
            }
        });
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.send_button) {
            this.presenter.sendClicked();
        } else if (id2 == R.id.cancel_button) {
            this.presenter.cancelClicked();
        }
    }

    protected void showAlertDialog(@StringRes int message) {
        new AlertDialog.Builder((Context)this, 5).setTitle(R.string.intercom_failed_to_send).setMessage(message).setNegativeButton(R.string.intercom_close, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).show();
    }

    protected void enableSendButton() {
        this.sendButton.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.intercom_white));
        this.sendButton.setEnabled(true);
    }

    protected void displayAttachmentDetails(String fileName, long size, @DrawableRes int resId) {
        this.attachmentDetails.setText((CharSequence)fileName);
        this.attachmentDetails.setVisibility(0);
        this.attachmentSize.setText((CharSequence)Formatter.formatFileSize((Context)this, (long)size).toLowerCase());
        this.attachmentSize.setVisibility(0);
        this.attachmentIcon.setVisibility(0);
        this.attachmentIcon.setImageResource(resId);
        this.spinner.setVisibility(8);
    }

    protected void displayFailedAttachment() {
        this.attachmentDetails.setText(R.string.intercom_file_failed);
        this.attachmentDetails.setVisibility(0);
        this.attachmentIcon.setVisibility(0);
        this.attachmentIcon.setImageResource(R.drawable.intercom_error);
        this.spinner.setVisibility(8);
    }

    protected void displayImage(File file, int width, int height) {
        DisplayMetrics metrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        width = width > metrics.widthPixels ? metrics.widthPixels : width;
        height = height > metrics.heightPixels ? metrics.heightPixels : height;
        DrawableTypeRequest requestCreator = Glide.with((FragmentActivity)this).load(file);
        if (width > 0 || height > 0) {
            requestCreator.override(width, height);
        }
        requestCreator.diskCacheStrategy(DiskCacheStrategy.NONE).listener((RequestListener)new RequestListener<File, GlideDrawable>(){

            public boolean onException(Exception e, File model, Target<GlideDrawable> target, boolean isFirstResource) {
                AttachmentActivity.this.twig.internal("images", "FAILED");
                AttachmentActivity.this.presenter.imageFailedToLoad();
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, File model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                AttachmentActivity.this.twig.internal("images", "SUCCESS");
                AttachmentActivity.this.previewImage.setVisibility(0);
                AttachmentActivity.this.spinner.setVisibility(8);
                return false;
            }
        }).into((ImageView)this.previewImage);
    }
}

