/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.MainThreadBus;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.overlay.OverlayManager;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.StoreFactory;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;
import javax.annotation.Nullable;

public class Injector
implements Api.Provider,
OverlayManager.Provider {
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Injector instance;
    private final Application application;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private static final Twig twig;
    @Nullable
    private MainThreadBus bus;
    @Nullable
    private NexusWrapper nexusClient;
    @Nullable
    private DeDuper superDeDuper;
    @Nullable
    private Api api;
    @Nullable
    private MetricsStore metricsStore;
    @Nullable
    private OverlayManager overlayManager;
    @Nullable
    private LifecycleTracker lifecycleTracker;
    @Nullable
    private SystemNotificationManager systemNotificationManager;
    @Nullable
    private Store<State> store;
    @Nullable
    private UserUpdateBatcher userUpdateBatcher;
    @Nullable
    private ResetManager resetManager;
    private final Provider<NexusClient> nexusClientProvider = new Provider<NexusClient>(){

        @Override
        public NexusClient get() {
            return Injector.this.getNexusClient();
        }
    };
    private final Provider<UserUpdateBatcher> userUpdateBatcherProvider = new Provider<UserUpdateBatcher>(){

        @Override
        public UserUpdateBatcher get() {
            return Injector.this.getUserUpdateBatcher();
        }
    };

    public static synchronized void init(Application application) {
        if (instance == null) {
            AppIdentity appIdentity = new AppIdentity((Context)application);
            Injector.initWithAppCredentials(application, appIdentity.getApiKey(), appIdentity.getAppId());
        }
    }

    static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance == null) {
            twig.internal("Injector", "Initializing");
            AppIdentity appIdentity = new AppIdentity((Context)application);
            appIdentity.update(apiKey, appId);
            instance = new Injector(application, appIdentity, new UserIdentity((Context)application));
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
        }
    }

    protected Injector(Application application, AppIdentity appIdentity, UserIdentity userIdentity) {
        this.application = application;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    public Application getApplication() {
        return this.application;
    }

    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public synchronized Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public synchronized NexusClient getNexusClient() {
        if (this.nexusClient == null) {
            this.nexusClient = new NexusWrapper(LumberMill.getNexusTwig(), this.getBus(), this.getStore());
        }
        return this.nexusClient;
    }

    public synchronized DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            SharedPreferences prefs = this.application.getSharedPreferences("INTERCOM_DEDUPER_PREFS", 0);
            this.superDeDuper = new DeDuper(this.getAppIdentity(), prefs);
            this.superDeDuper.readPersistedCachedAttributes();
        }
        return this.superDeDuper;
    }

    @Override
    public synchronized Api getApi() {
        if (this.api == null) {
            String hostname = ApiFactory.getHostname(this.getAppIdentity());
            this.api = ApiFactory.create((Context)this.getApplication(), this.getAppIdentity(), this.getUserIdentity(), this.getBus(), this.getStore(), hostname);
        }
        this.api.updateMaxRequests();
        return this.api;
    }

    public synchronized MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this, this.getAppIdentity());
            this.metricsStore.loadCachedMetrics();
        }
        return this.metricsStore;
    }

    @Override
    public synchronized OverlayManager getOverlayManager() {
        if (this.overlayManager == null) {
            this.overlayManager = new OverlayManager(this.getApplication(), this.getBus(), this.getStore(), this.getAppIdentity(), this.getMetricsStore(), new MetricFactory(this.getUserIdentity()), this, this.getUserIdentity());
        }
        return this.overlayManager;
    }

    public synchronized Store<State> getStore() {
        if (this.store == null) {
            this.store = StoreFactory.createStore(this, this.getAppIdentity(), this.nexusClientProvider, this, this.userUpdateBatcherProvider, new SoundPlayer((Context)this.application), this.getUserIdentity());
        }
        return this.store;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public synchronized SystemNotificationManager getSystemNotificationManager() {
        if (this.systemNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)this.application.getSystemService("notification");
            this.systemNotificationManager = new SystemNotificationManager(notificationManager);
        }
        return this.systemNotificationManager;
    }

    public synchronized LifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = LifecycleTracker.create(this.getSystemNotificationManager(), this.getMetricsStore(), this.getDeDuper(), this.getTimeProvider(), this.getUserUpdateBatcher(), this.getStore(), this.getResetManager(), SystemSettings.getTransitionScale((Context)this.application));
        }
        return this.lifecycleTracker;
    }

    public synchronized UserUpdateBatcher getUserUpdateBatcher() {
        if (this.userUpdateBatcher == null) {
            this.userUpdateBatcher = UserUpdateBatcher.create(this, this.getAppIdentity());
        }
        return this.userUpdateBatcher;
    }

    public synchronized ResetManager getResetManager() {
        if (this.resetManager == null) {
            this.resetManager = new ResetManager(this, this.getUserIdentity(), this.getOverlayManager(), this.getAppIdentity(), this.getStore(), this.getBus(), this.getUserUpdateBatcher(), (Context)this.application);
        }
        return this.resetManager;
    }

    public Provider<UserUpdateBatcher> getUserUpdateBatcherProvider() {
        return this.userUpdateBatcherProvider;
    }

    @VisibleForTesting
    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    static {
        twig = LumberMill.getLogger();
    }
}

