/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;

class PushBroadcast {
    private final Uri pushData;
    private final String pushOnlyId;
    private final Twig twig = TwigFactory.getLogger();

    PushBroadcast() {
        this.pushData = Uri.EMPTY;
        this.pushOnlyId = "";
    }

    PushBroadcast(Intent intent) {
        String uriPushOnlyId = intent.getStringExtra("push_only_convo_id");
        if (TextUtils.isEmpty((CharSequence)uriPushOnlyId)) {
            this.twig.internal("The uri had no push only id");
            this.pushOnlyId = "";
        } else {
            this.pushOnlyId = uriPushOnlyId;
        }
        Uri data = intent.getData();
        if (data == null) {
            this.twig.internal("The uri had no push data");
            this.pushData = Uri.EMPTY;
        } else {
            this.pushData = data;
        }
    }

    Uri getPushData() {
        return this.pushData;
    }

    String getPushOnlyId() {
        return this.pushOnlyId;
    }

    boolean isEmpty() {
        return Uri.EMPTY.equals((Object)this.pushData) && this.pushOnlyId.isEmpty();
    }

    boolean hasPushOnlyId() {
        return !TextUtils.isEmpty((CharSequence)this.pushOnlyId);
    }
}

