/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.InvalidIntercom;
import io.intercom.android.sdk.LateInitializationPreparer;
import io.intercom.android.sdk.RealIntercom;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.User;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.util.Map;

public abstract class Intercom {
    public static final Visibility VISIBLE = Visibility.VISIBLE;
    public static final Visibility GONE = Visibility.GONE;
    public static final String GCM_RECEIVER = "intercom_sdk";
    private static final Twig TWIG = TwigFactory.getLogger();
    @SuppressLint(value={"StaticFieldLeak"})
    private static final LateInitializationPreparer lateInitializationPreparer = new LateInitializationPreparer();
    @Nullable
    private static Intercom instance;

    public static synchronized void initialize(Application application, String apiKey, String appId) {
        if (instance != null) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            return;
        }
        if (ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            instance = RealIntercom.create(application, apiKey, appId);
            lateInitializationPreparer.handlePastLifecycleEvents(application, Injector.get());
        } else {
            instance = new InvalidIntercom();
        }
    }

    public static synchronized void registerForLaterInitialisation(@NonNull Application application) {
        if (instance != null) {
            TWIG.i("Intercom has already been initialized", new Object[0]);
            return;
        }
        if (application == null) {
            throw new NullPointerException("Cannot call registerForLaterInitialisation() with a null Application");
        }
        lateInitializationPreparer.register(application);
    }

    public static void unregisterForLateInitialisation(@NonNull Application application) {
        if (application == null) {
            throw new NullPointerException("Cannot call registerForLaterInitialisation() with a null Application");
        }
        lateInitializationPreparer.unregister(application);
    }

    public static synchronized Intercom client() {
        if (instance == null) {
            throw new IllegalStateException("Please call Intercom.initialize() before requesting the client.");
        }
        return instance;
    }

    public abstract void registerUnidentifiedUser();

    public abstract void registerIdentifiedUser(Registration var1);

    public abstract void setSecureMode(String var1, String var2);

    @Deprecated
    public abstract void updateUser(Map<String, ?> var1);

    public abstract void updateUser(User var1);

    public abstract void logEvent(String var1);

    public abstract void logEvent(String var1, Map<String, ?> var2);

    public abstract void displayMessenger();

    public abstract void displayMessageComposer();

    public abstract void displayMessageComposer(String var1);

    public abstract void displayConversationsList();

    public abstract void setInAppMessageVisibility(Visibility var1);

    public abstract void setLauncherVisibility(Visibility var1);

    public abstract void hideMessenger();

    @Deprecated
    public abstract void openGcmMessage();

    @Deprecated
    public abstract void openGcmMessage(TaskStackBuilder var1);

    public abstract void handlePushMessage();

    public abstract void handlePushMessage(TaskStackBuilder var1);

    public abstract void reset();

    public abstract int getUnreadConversationCount();

    public abstract void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener var1);

    public abstract void removeUnreadConversationCountListener(UnreadConversationCountListener var1);

    public static void setLogLevel(int logLevel) {
        TwigFactory.setLogLevel(logLevel);
    }

    public static enum Visibility {
        GONE,
        VISIBLE;

    }
}

