/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public class Company {
    private static final String COMPANY_ID = "id";
    private static final String NAME = "name";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String CREATED_AT = "created_at";
    private static final String MONTHLY_SPEND = "monthly_spend";
    private static final String PLAN = "plan";
    private final Map<String, Object> attributes;
    private final Map<String, Object> customAttributes;

    Company(Builder builder) {
        this.attributes = builder.attributes;
        this.customAttributes = builder.customAttributes;
    }

    Map<String, Object> getAttributes() {
        if (!this.customAttributes.isEmpty()) {
            this.attributes.put(CUSTOM_ATTRIBUTES, this.customAttributes);
        }
        return this.attributes;
    }

    public static final class Builder {
        final Map<String, Object> attributes = new HashMap<String, Object>();
        final Map<String, Object> customAttributes = new HashMap<String, Object>();

        public Company build() {
            return new Company(this);
        }

        public Builder withCompanyId(@Nullable String companyId) {
            this.attributes.put(Company.COMPANY_ID, companyId);
            return this;
        }

        public Builder withName(@Nullable String name) {
            this.attributes.put(Company.NAME, name);
            return this;
        }

        public Builder withCreatedAt(@Nullable Long createdAt) {
            this.attributes.put(Company.CREATED_AT, createdAt);
            return this;
        }

        public Builder withMonthlySpend(@Nullable Integer monthlySpend) {
            this.attributes.put(Company.MONTHLY_SPEND, monthlySpend);
            return this;
        }

        public Builder withPlan(@Nullable String plan) {
            this.attributes.put(Company.PLAN, plan);
            return this;
        }

        public Builder withCustomAttribute(@NonNull String key, @Nullable Object attribute) {
            this.customAttributes.put(key, attribute);
            return this;
        }

        public Builder withCustomAttributes(@NonNull Map<String, ?> attributes) {
            this.customAttributes.putAll(attributes);
            return this;
        }
    }
}

