/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class ApiMiddleware
implements Store.Middleware<State> {
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;

    public ApiMiddleware(Api.Provider apiProvider, AppConfig.Provider appConfigProvider) {
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        long currentTime;
        long timeSinceBackgrounded;
        next.dispatch(action);
        if (action.type() == Action.Type.APP_ENTERED_FOREGROUND && (timeSinceBackgrounded = (currentTime = ((Long)action.value()).longValue()) - store.state().hostAppState().backgroundedTimestamp()) > this.appConfigProvider.getAppConfig().getNewSessionThresholdMs()) {
            this.apiProvider.getApi().ping();
        }
    }
}

