/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.app.Application;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityOptionsCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomArticleActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.LinkOpener;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.PartMetadataFormatter;
import io.intercom.android.sdk.views.holder.ContainerCardViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationLoadingViewHolder;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;
import io.intercom.android.sdk.views.holder.LinkViewHolder;
import io.intercom.android.sdk.views.holder.PartViewHolder;
import io.intercom.android.sdk.views.holder.TimeStampViewHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConversationPartAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ConversationListener {
    private final PartMetadataFormatter partMetadataFormatter;
    private final List<Part> partList;
    private final ClipboardManager clipboardManager;
    private final PartClickedListener partClickedListener;
    private final TimeFormatter timeFormatter;
    private final Map<Part, ViewGroup> blockViewMap;
    private final Api api;
    private final Activity rootActivity;
    private final String conversationId;
    private boolean allowExpansionArrow = false;
    @Nullable
    private Part selectedPart;
    private LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;

    public static ConversationPartAdapter create(Activity rootActivity, List<Part> partList, PartClickedListener partClickedListener, Api api, String conversationId) {
        ClipboardManager clipboardManager = (ClipboardManager)rootActivity.getSystemService("clipboard");
        Context localisedContext = ContextLocaliser.create().createLocalisedContext((Context)rootActivity);
        TimeFormatter timeFormatter = new TimeFormatter(localisedContext, Injector.get().getTimeProvider());
        PartMetadataFormatter partMetadataFormatter = PartMetadataFormatter.create((Context)rootActivity, timeFormatter);
        return new ConversationPartAdapter(partList, clipboardManager, partClickedListener, partMetadataFormatter, timeFormatter, new HashMap<Part, ViewGroup>(), api, rootActivity, conversationId);
    }

    ConversationPartAdapter(List<Part> partList, ClipboardManager clipboardManager, PartClickedListener partClickedListener, PartMetadataFormatter partMetadataFormatter, TimeFormatter timeFormatter, Map<Part, ViewGroup> blockViewMap, Api api, Activity rootActivity, String conversationId) {
        this.partList = partList;
        this.clipboardManager = clipboardManager;
        this.partClickedListener = partClickedListener;
        this.partMetadataFormatter = partMetadataFormatter;
        this.timeFormatter = timeFormatter;
        this.blockViewMap = blockViewMap;
        this.api = api;
        this.rootActivity = rootActivity;
        this.conversationId = conversationId;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 6: {
                return new TimeStampViewHolder(inflater.inflate(R.layout.intercom_day_divider, parent, false), this.timeFormatter);
            }
            case 1: 
            case 4: 
            case 5: {
                return new PartViewHolder(inflater.inflate(R.layout.intercom_row_admin_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter);
            }
            case 2: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_post, parent, false), viewType, this, this.clipboardManager, false);
            }
            case 3: {
                return new ContainerCardViewHolder(inflater.inflate(R.layout.intercom_row_note, parent, false), viewType, this, this.clipboardManager, this.allowExpansionArrow);
            }
            case 7: {
                View view = inflater.inflate(R.layout.intercom_row_loading, parent, false);
                return new ConversationLoadingViewHolder(view);
            }
            case 8: {
                return new LinkViewHolder(inflater.inflate(R.layout.intercom_row_link, parent, false), viewType, this, this.clipboardManager);
            }
            case 9: {
                return new LinkViewHolder(inflater.inflate(R.layout.intercom_row_link_reply, parent, false), viewType, this, this.clipboardManager);
            }
        }
        return new PartViewHolder(inflater.inflate(R.layout.intercom_row_user_part, parent, false), viewType, this, this.clipboardManager, this.partMetadataFormatter);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ConversationPartViewHolder) {
            Part part = this.getPart(position);
            ViewGroup blocksLayout = this.blockViewMap.get(part);
            if (blocksLayout == null) {
                blocksLayout = new FrameLayout(holder.itemView.getContext());
            }
            ((ConversationPartViewHolder)holder).bind(part, blocksLayout);
        }
    }

    public void setLastParticipatingAdmin(LastParticipatingAdmin lastParticipatingAdmin) {
        this.lastParticipatingAdmin = lastParticipatingAdmin;
    }

    public int getItemViewType(int position) {
        Part conversationPart = this.partList.get(position);
        String messageStyle = conversationPart.getMessageStyle();
        int type = 0;
        if ("admin_is_typing_style".equals(messageStyle)) {
            return 5;
        }
        if ("day_divider_style".equals(messageStyle)) {
            return 6;
        }
        if ("loading_layout_style".equals(messageStyle)) {
            return 7;
        }
        Participant user = conversationPart.getParticipant();
        if ("admin".equals(user.getType())) {
            if (conversationPart.isLinkCard()) {
                type = conversationPart.isInitialMessage() ? 8 : 9;
            } else if ("post".equals(messageStyle)) {
                type = 2;
            } else if ("note".equals(messageStyle)) {
                this.startAllowingExpansionArrowIfPositionIsNotLast(position);
                type = 3;
            } else {
                type = 1;
            }
        } else if (!user.getId().equals(Injector.get().getUserIdentity().getIntercomId())) {
            type = 4;
        }
        return type;
    }

    private void startAllowingExpansionArrowIfPositionIsNotLast(int position) {
        this.allowExpansionArrow |= position != this.partList.size() - 1;
    }

    public int getItemCount() {
        return this.partList.size();
    }

    @Override
    public int getCount() {
        return this.getItemCount();
    }

    @Override
    public Part getPart(int position) {
        return this.partList.get(position);
    }

    @Override
    @Nullable
    public Part getSelectedPart() {
        return this.selectedPart;
    }

    @Override
    public void onPartClicked(int position, PartViewHolder partViewHolder) {
        Part part = this.partList.get(position);
        if (part.getMessageState() == Part.MessageState.FAILED || part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.partClickedListener.onPartClicked(part);
        } else if (position >= this.getCount() - 1) {
            if (part == this.selectedPart) {
                this.selectedPart = null;
                partViewHolder.setExpanded(false);
            } else {
                int index = this.partList.indexOf(this.selectedPart);
                this.notifyItemChanged(index);
                this.selectedPart = part;
                partViewHolder.setExpanded(true);
            }
        }
    }

    @Override
    public void onContainerCardClicked(int position, ContainerCardViewHolder containerCardViewHolder) {
        Part part = this.partList.get(position);
        switch (this.getItemViewType(position)) {
            case 3: {
                if (!this.allowExpansionArrow) break;
                containerCardViewHolder.toggleExpanded();
                break;
            }
            case 2: {
                Application context = Injector.get().getApplication();
                context.startActivity(IntercomPostActivity.buildPostIntent((Context)context, part, "", this.lastParticipatingAdmin, false));
                break;
            }
        }
    }

    @Override
    public void onLinkClicked(int position, View background) {
        Part part = this.partList.get(position);
        Block linkBlock = part.getLinkBlock();
        if ("educate.article".equals(linkBlock.getLinkType())) {
            this.openArticleActivity(linkBlock, part, background);
        } else {
            LinkOpener.handleUrl(linkBlock.getUrl(), (Context)this.rootActivity, this.api);
        }
    }

    private void openArticleActivity(Block linkBlock, Part part, View background) {
        Intent intent = IntercomArticleActivity.buildIntent((Context)this.rootActivity, linkBlock.getArticleId(), part.getId(), this.conversationId);
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityOptionsCompat options = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)this.rootActivity, (View)background, (String)"link_background");
            this.rootActivity.startActivity(intent, options.toBundle());
        } else {
            this.rootActivity.startActivity(intent);
        }
    }

    public void setLayoutForBlock(Part part, ViewGroup blocks) {
        this.blockViewMap.put(part, blocks);
    }

    public ViewGroup getLayoutForPart(Part part) {
        return this.blockViewMap.get(part);
    }

    public static interface PartClickedListener {
        public void onPartClicked(Part var1);
    }
}

