/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.MainThreadBus;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.overlay.OverlayManager;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selection;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.StoreFactory;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;
import javax.annotation.Nullable;

public class Injector
implements Api.Provider {
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Injector instance;
    private final Application application;
    private final AppIdentity appIdentity;
    @Nullable
    private MainThreadBus bus;
    @Nullable
    private NexusWrapper nexusClient;
    @Nullable
    private UserIdentity userIdentity;
    @Nullable
    private DeDuper superDeDuper;
    @Nullable
    private Api api;
    @Nullable
    private MetricsStore metricsStore;
    @Nullable
    private OverlayManager overlayManager;
    @Nullable
    private LifecycleTracker lifecycleTracker;
    @Nullable
    private SystemNotificationManager systemNotificationManager;
    @Nullable
    private Store<State> store;
    @Nullable
    private UserUpdater userUpdater;

    public static synchronized void init(Application application) {
        if (instance == null) {
            AppIdentity appIdentity = new AppIdentity((Context)application);
            Injector.initWithAppCredentials(application, appIdentity.getApiKey(), appIdentity.getAppId());
        }
    }

    static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance == null) {
            IntercomLogger.internal("Injector", "Initializing");
            AppIdentity appIdentity = new AppIdentity((Context)application);
            appIdentity.update(apiKey, appId);
            instance = new Injector(application, appIdentity);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
        }
    }

    protected Injector(Application application, AppIdentity appIdentity) {
        this.application = application;
        this.appIdentity = appIdentity;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    public Application getApplication() {
        return this.application;
    }

    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    public UserIdentity getUserIdentity() {
        if (this.userIdentity == null) {
            this.userIdentity = new UserIdentity((Context)this.getApplication());
        }
        return this.userIdentity;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public NexusClient getNexusClient() {
        if (this.nexusClient == null) {
            this.nexusClient = new NexusWrapper(this.getBus(), TwigFactory.getNexusTwig());
        }
        return this.nexusClient;
    }

    public DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            this.superDeDuper = new DeDuper(this.getAppIdentity());
        }
        return this.superDeDuper;
    }

    @Override
    public Api getApi() {
        if (this.api == null) {
            String hostname = ApiFactory.getHostname(this.getAppIdentity());
            this.api = ApiFactory.create((Context)this.getApplication(), this.getAppIdentity(), this.getUserIdentity(), this.getBus(), this.getNexusClient(), this.getStore(), hostname);
        }
        this.api.updateMaxRequests();
        return this.api;
    }

    public MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this, this.getAppIdentity());
            this.metricsStore.loadCachedMetrics();
        }
        return this.metricsStore;
    }

    public OverlayManager getOverlayManager() {
        if (this.overlayManager == null) {
            this.overlayManager = new OverlayManager(this.getApplication(), this.getBus(), this.getStore(), this.getAppIdentity(), new SoundPlayer((Context)this.getApplication()), this.getMetricsStore(), new MetricFactory(this.getUserIdentity()), this.getApi(), this.getUserIdentity());
        }
        return this.overlayManager;
    }

    public Store<State> getStore() {
        if (this.store == null) {
            this.store = StoreFactory.createStore(this, this.getAppIdentity());
        }
        return this.store;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public SystemNotificationManager getSystemNotificationManager() {
        if (this.systemNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)this.application.getSystemService("notification");
            this.systemNotificationManager = new SystemNotificationManager(notificationManager);
        }
        return this.systemNotificationManager;
    }

    public LifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = new LifecycleTracker(this.getDeDuper(), this.getMetricsStore(), this.getNexusClient(), this.getAppIdentity(), this.getTimeProvider(), this.getSystemNotificationManager(), this.getUserUpdater(), this.getStore(), Selection.create(this.getStore(), Selectors.IS_BACKGROUNDED));
        }
        return this.lifecycleTracker;
    }

    public UserUpdater getUserUpdater() {
        if (this.userUpdater == null) {
            this.userUpdater = UserUpdater.create(this, this.getAppIdentity());
        }
        return this.userUpdater;
    }

    @VisibleForTesting
    static void setSharedInstance(Injector injector) {
        instance = injector;
    }
}

