/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.content.Context;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.conversation.events.CancelAdminTypingEvent;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.concurrent.TimeUnit;

public class AdminIsTypingView
extends LinearLayout {
    private static final int IS_TYPING_DURATION_SECONDS = 10;
    private static final int ANIMATION_DELAY_MILLIS = 100;
    private final ImageView[] dots = new ImageView[3];
    private final AnimatorSet[] dotsAnimations = new AnimatorSet[3];
    private final String partId;
    private final String adminId;
    private final String conversationId;
    private boolean animating = false;
    private final Runnable animateDots = new Runnable(){

        @Override
        public void run() {
            for (int i = 0; i < AdminIsTypingView.this.dots.length; ++i) {
                AdminIsTypingView.this.dotsAnimations[i].setTarget((Object)AdminIsTypingView.this.dots[i]);
                AdminIsTypingView.this.dotsAnimations[i].start();
            }
            AdminIsTypingView.this.postDelayed(AdminIsTypingView.this.animateDots, TimeUnit.SECONDS.toMillis(1L));
        }
    };
    private final Runnable endAnimation = new Runnable(){

        @Override
        public void run() {
            AdminIsTypingView.this.animating = false;
            IntercomLogger.internal("isTyping", "ending animation");
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.animateDots);
            AdminIsTypingView.this.removeCallbacks(AdminIsTypingView.this.endAnimation);
            Injector.get().getBus().unregister((Object)AdminIsTypingView.this);
            Injector.get().getBus().post((Object)new AdminTypingEndedEvent(AdminIsTypingView.this.adminId, AdminIsTypingView.this.partId));
            for (AnimatorSet set : AdminIsTypingView.this.dotsAnimations) {
                set.cancel();
            }
        }
    };

    public AdminIsTypingView(Context context) {
        this(context, "", "", "");
    }

    public AdminIsTypingView(Context context, String adminId, String conversationId, String partId) {
        super(context);
        AdminIsTypingView.inflate((Context)this.getContext(), (int)R.layout.intercom_admin_is_typing, (ViewGroup)this);
        this.adminId = adminId;
        this.conversationId = conversationId;
        this.partId = partId;
        this.dots[0] = (ImageView)this.findViewById(R.id.dot1);
        this.dots[1] = (ImageView)this.findViewById(R.id.dot2);
        this.dots[2] = (ImageView)this.findViewById(R.id.dot3);
        for (int i = 0; i < this.dotsAnimations.length; ++i) {
            this.dotsAnimations[i] = (AnimatorSet)AnimatorInflater.loadAnimator((Context)this.getContext(), (int)R.animator.intercom_admin_is_typing);
            this.dotsAnimations[i].setStartDelay((long)(i * 100));
        }
        this.setupEndCondition();
        Injector.get().getBus().register((Object)this);
    }

    public void beginAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animateDots.run();
        }
    }

    private void setupEndCondition() {
        this.postDelayed(this.endAnimation, TimeUnit.SECONDS.toMillis(10L));
    }

    @Subscribe
    public void renewTypingAnimation(AdminIsTypingEvent event) {
        if (event.getAdminId().equals(this.adminId) && event.getConversationId().equals(this.conversationId)) {
            this.removeCallbacks(this.endAnimation);
            this.setupEndCondition();
        }
    }

    @Subscribe
    public void cancelTypingAnimation(CancelAdminTypingEvent ignored) {
        this.endAnimation.run();
    }
}

