/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.os.Vibrator;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.conversation.ReactionListener;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Reaction;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReactionInputView
extends LinearLayout {
    private static final float REACTION_SCALE = 2.5f;
    private static final int VIBRATION_DURATION_MS = 10;
    private final List<ImageView> reactionViews;
    private final LongTermImageLoader longTermImageLoader;
    private final Vibrator vibrator;
    private final ColorFilter deselectedFilter;
    private String conversationId = "";
    private String partId = "";
    private String articleId = "";
    private Integer highlightedViewIndex = null;
    private int reactionsLoaded = 0;
    private ReactionReply reactionReply;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;
    private ReactionListener listener;
    private ReactionLocation reactionLocation = ReactionLocation.IN_APP;
    private final View.OnTouchListener touchListener = new View.OnTouchListener(){
        private final Rect touchRect = new Rect();

        public boolean onTouch(View view, MotionEvent event) {
            int action = event.getActionMasked();
            switch (action) {
                case 0: 
                case 2: {
                    this.handleTouchMove(event);
                    break;
                }
                case 1: {
                    ReactionInputView.this.handleTouchUp();
                    break;
                }
            }
            return true;
        }

        private void handleTouchMove(MotionEvent event) {
            ReactionInputView.this.getHitRect(this.touchRect);
            if (this.touchRect.contains((int)event.getX(), (int)event.getY())) {
                for (int i = 0; i < ReactionInputView.this.getChildCount(); ++i) {
                    ReactionInputView.this.getChildAt(i).getHitRect(this.touchRect);
                    if (!this.touchRect.contains((int)event.getX(), (int)event.getY())) continue;
                    if (ReactionInputView.this.highlightedViewIndex == null || ReactionInputView.this.highlightedViewIndex != i) {
                        ReactionInputView.this.vibrateForSelection();
                        ReactionInputView.this.selectViewAtIndex(2.5f, i);
                    }
                    if (ReactionInputView.this.highlightedViewIndex == null) {
                        Integer index = ReactionInputView.this.getCurrentSelectedIndex();
                        if (index != null && index != i) {
                            ReactionInputView.this.deselectViewAtIndex(index);
                        }
                    } else if (ReactionInputView.this.highlightedViewIndex != i) {
                        ReactionInputView.this.deselectViewAtIndex(ReactionInputView.this.highlightedViewIndex);
                    }
                    ReactionInputView.this.highlightedViewIndex = i;
                }
            } else {
                if (ReactionInputView.this.highlightedViewIndex != null) {
                    ReactionInputView.this.highlightSelectedReaction();
                }
                ReactionInputView.this.highlightedViewIndex = null;
            }
        }
    };

    public ReactionInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ReactionInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.reactionViews = new ArrayList<ImageView>();
        this.setVisibility(8);
        if (this.isInEditMode()) {
            this.longTermImageLoader = null;
            this.vibrator = null;
        } else {
            this.longTermImageLoader = LongTermImageLoader.newInstance(context);
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
        }
        this.deselectedFilter = ColorUtils.newGreyscaleFilter();
    }

    public void setListener(ReactionListener listener) {
        this.listener = listener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnTouchListener(this.touchListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setOnTouchListener(null);
        if (!this.isInEditMode()) {
            try {
                this.longTermImageLoader.close();
            }
            catch (IOException e) {
                IntercomLogger.d("Couldn't close LongTermImageLoader: " + e.getMessage());
            }
        }
    }

    public void setUpReactions(ReactionReply reactionReply, String conversationId, String partId, String articleId, ReactionLocation reactionLocation, final boolean animated, @NonNull MetricsStore metricsStore, @NonNull MetricFactory metricFactory) {
        final Context context = this.getContext();
        this.reactionReply = reactionReply;
        this.conversationId = conversationId;
        this.partId = partId;
        this.reactionLocation = reactionLocation;
        this.metricStore = metricsStore;
        this.metricFactory = metricFactory;
        this.articleId = articleId;
        List<Reaction> reactionSet = reactionReply.getReactionSet();
        final int reactionCount = reactionSet.size();
        for (int i = 0; i < reactionSet.size(); ++i) {
            FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setClipChildren(false);
            frameLayout.setClipToPadding(false);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            final ImageView reactionImageView = new ImageView(context);
            int imageSizePx = this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_size);
            reactionImageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(imageSizePx, imageSizePx, 17));
            reactionImageView.setPivotY((float)this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_offset));
            reactionImageView.setPivotX((float)(imageSizePx / 2));
            this.reactionViews.add(reactionImageView);
            frameLayout.addView((View)reactionImageView);
            Reaction reaction = reactionSet.get(i);
            this.longTermImageLoader.loadImage(reaction.getImageUrl(), this.getContext(), new LongTermImageLoader.OnImageReadyListener(){

                @Override
                public void onImageReady(Bitmap bitmap) {
                    reactionImageView.setImageBitmap(bitmap);
                    ReactionInputView.this.reactionsLoaded++;
                    if (ReactionInputView.this.reactionsLoaded == reactionCount) {
                        if (animated) {
                            ReactionInputView.this.setVisibility(0);
                            ReactionInputView.this.setY(ReactionInputView.this.getHeight() + ScreenUtils.dpToPx((float)60.0f, (Context)context));
                            ReactionInputView.this.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).translationY(0.0f).setDuration(300L).start();
                        } else {
                            ReactionInputView.this.setVisibility(0);
                        }
                    }
                }
            });
            Integer selectedReactionIndex = reactionReply.getReactionIndex();
            if (selectedReactionIndex != null && !selectedReactionIndex.equals(reaction.getIndex())) {
                this.deselectViewAtIndex(i);
            }
            this.addView((View)frameLayout);
        }
    }

    public void preloadReactionImages(ReactionReply reactionReply) {
        for (Reaction reaction : reactionReply.getReactionSet()) {
            this.longTermImageLoader.loadImage(reaction.getImageUrl(), this.getContext(), null);
        }
    }

    private void vibrateForSelection() {
        if (DeviceUtils.hasPermission((Context)this.getContext(), (String)"android.permission.VIBRATE")) {
            this.vibrator.vibrate(10L);
        }
    }

    private void handleTouchUp() {
        Reaction selectedReaction;
        if (this.highlightedViewIndex != null && this.highlightedViewIndex >= 0 && this.highlightedViewIndex < this.reactionReply.getReactionSet().size() && (selectedReaction = this.reactionReply.getReactionSet().get(this.highlightedViewIndex)) != null && (this.reactionReply.getReactionIndex() == null || selectedReaction.getIndex() != this.reactionReply.getReactionIndex().intValue())) {
            this.reactionReply.setReactionIndex(selectedReaction.getIndex());
            this.sendReactionRequest(selectedReaction);
        }
        this.highlightSelectedReaction();
        this.highlightedViewIndex = null;
    }

    private void sendReactionRequest(Reaction selectedReaction) {
        if (this.reactionLocation == ReactionLocation.LINK) {
            Injector.get().getApi().reactToLink(this.articleId, selectedReaction.getIndex());
        } else {
            Injector.get().getApi().reactToConversation(this.conversationId, selectedReaction.getIndex());
            this.metricStore.track(this.metricFactory.sentReaction(this.conversationId, this.partId, selectedReaction.getIndex(), this.reactionLocation));
        }
        if (this.listener != null) {
            this.listener.onReactionSelected();
        }
    }

    private void highlightSelectedReaction() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Integer selectedReactionIndex = this.reactionReply.getReactionIndex();
            Reaction reaction = this.reactionReply.getReactionSet().get(i);
            if (selectedReactionIndex == null || selectedReactionIndex.equals(reaction.getIndex())) {
                this.selectViewAtIndex(1.0f, i);
                continue;
            }
            this.deselectViewAtIndex(i);
        }
    }

    private Integer getCurrentSelectedIndex() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Integer selectedReactionIndex = this.reactionReply.getReactionIndex();
            Reaction reaction = this.reactionReply.getReactionSet().get(i);
            if (selectedReactionIndex != null && !selectedReactionIndex.equals(reaction.getIndex())) continue;
            return i;
        }
        return null;
    }

    private void selectViewAtIndex(float scale, int index) {
        ImageView reactionView = this.reactionViews.get(index);
        reactionView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(2.0f)).scaleX(scale).scaleY(scale).setDuration(200L).start();
        reactionView.clearColorFilter();
    }

    private void deselectViewAtIndex(int index) {
        ImageView reactionView = this.reactionViews.get(index);
        reactionView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).scaleX(1.0f).scaleY(1.0f).setDuration(200L).start();
        reactionView.setColorFilter(this.deselectedFilter);
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP,
        LINK;

    }
}

