/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.state;

import android.support.annotation.NonNull;
import io.intercom.android.sdk.models.Conversation;
import java.util.List;

public class InboxState {
    @NonNull
    private final List<Conversation> conversations;
    @NonNull
    private final Status status;
    private final boolean hasMorePages;

    public InboxState(@NonNull List<Conversation> conversations, @NonNull Status status, boolean hasMorePages) {
        this.conversations = conversations;
        this.status = status;
        this.hasMorePages = hasMorePages;
    }

    @NonNull
    public List<Conversation> conversations() {
        return this.conversations;
    }

    @NonNull
    public Status status() {
        return this.status;
    }

    public boolean hasMorePages() {
        return this.hasMorePages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboxState that = (InboxState)o;
        if (this.hasMorePages != that.hasMorePages) {
            return false;
        }
        if (!this.conversations.equals(that.conversations)) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.conversations.hashCode();
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (this.hasMorePages ? 1 : 0);
        return result;
    }

    public static enum Status {
        INITIAL,
        LOADING,
        SUCCESS,
        FAILED;

    }
}

