/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.push.IntercomNotificationManager;
import io.intercom.android.sdk.push.IntercomPushHandler;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;

public class IntercomPushClient {
    private final IntercomPushHandler intercomPushHandler = new IntercomPushHandler();

    public void sendTokenToIntercom(Application application, String token) {
        Injector.init(application);
        if (this.intercomPushHandler.shouldSendDeviceToken((Context)application, token)) {
            this.intercomPushHandler.sendTokenToIntercom((Context)application, token, Injector.get().getApi());
        }
    }

    public void handlePush(Application application, Bundle message) {
        if (!this.isIntercomPush(message)) {
            IntercomLogger.i("The message passed to handlePush was not an Intercom push message.");
            return;
        }
        Injector.init(application);
        Context localisedContext = new ContextLocaliser(Injector.get().getAppIdentity()).createLocalisedContext((Context)application);
        boolean appBackgrounded = Injector.get().getLifecycleTracker().isAppBackgrounded();
        UserIdentity userIdentity = Injector.get().getUserIdentity();
        MetricFactory metricFactory = new MetricFactory(userIdentity);
        IntercomNotificationManager intercomNotificationManager = Injector.get().getIntercomNotificationManager();
        this.intercomPushHandler.handlePush(message, userIdentity, intercomNotificationManager, Injector.get().getMetricsStore(), appBackgrounded, localisedContext, metricFactory);
    }

    public void handlePush(Application application, Map<String, String> message) {
        this.handlePush(application, this.convertMessageMapToBundle(message));
    }

    public boolean isIntercomPush(Bundle message) {
        return this.intercomPushHandler.isIntercomPush(message);
    }

    public boolean isIntercomPush(Map<String, String> message) {
        return this.isIntercomPush(this.convertMessageMapToBundle(message));
    }

    private Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }
}

