/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.api.IntercomApiInterface;
import io.intercom.android.sdk.api.ProgressRequestBody;
import io.intercom.android.sdk.attachments.AttachmentData;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.models.UpdateUserResponse;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.events.ReadEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.okhttp3.Dispatcher;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.MultipartBody;
import io.intercom.okhttp3.OkHttpClient;
import io.intercom.okhttp3.Request;
import io.intercom.okhttp3.RequestBody;
import io.intercom.okhttp3.Response;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Api {
    private static final String USER = "user";
    private static final String DEVICE_TOKEN = "device_token";
    private static final String USER_ATTRIBUTES = "user_attributes";
    private static final String DEVICE_DATA = "device_data";
    private static final String NEW_SESSION = "new_session";
    private static final String HMAC = "hmac";
    private static final String DATA = "data";
    private static final String UPLOAD = "upload";
    private final CallbackHolder callbacks;
    private final Context context;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private final OkHttpClient httpClient = new OkHttpClient();
    private final Bus bus;
    private final IntercomApiInterface intercomApiInterface;
    private final OkHttpClient apiHttpClient;
    private final int defaultOkHttpMaxRequests;

    public Api(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Bus bus, OkHttpClient httpClient, IntercomApiInterface intercomApiInterface, CallbackHolder callbacks) {
        this.context = context;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.bus = bus;
        this.intercomApiInterface = intercomApiInterface;
        this.apiHttpClient = httpClient;
        this.defaultOkHttpMaxRequests = httpClient.dispatcher().getMaxRequests();
        this.callbacks = callbacks;
        this.updateMaxRequests();
    }

    public void updateMaxRequests() {
        int maxRequests = this.userIdentity.hasIntercomId() ? this.defaultOkHttpMaxRequests : 1;
        Dispatcher dispatcher = this.apiHttpClient.dispatcher();
        if (dispatcher.getMaxRequests() != maxRequests) {
            dispatcher.setMaxRequests(maxRequests);
        }
    }

    public void registerUnidentifiedUser() {
        Injector.get().getNexusClient().disconnect();
        this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(this.context), true), this.userIdentity.getFingerprint());
    }

    public void registerIdentifiedUser(Registration registration) {
        Injector.get().getNexusClient().disconnect();
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.context);
        Map<String, Object> params = this.generateUpdateUserParams(deviceData, true);
        params.put(USER_ATTRIBUTES, registration.getAttributes());
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    public void ping() {
        if (this.userIdentity.identityExists() && this.appIdentity.identityExists()) {
            this.retriableUpdateUser(this.generateUpdateUserParams(DeviceData.generateDeviceData(this.context), true), this.userIdentity.getFingerprint());
        }
    }

    public void setDeviceToken(String deviceToken) {
        Map<String, Object> deviceData = DeviceData.generateDeviceData(this.context);
        deviceData.put(DEVICE_TOKEN, deviceToken);
        this.retriableUpdateUser(this.generateUpdateUserParams(deviceData, false), this.userIdentity.getFingerprint());
    }

    public void removeGcmDeviceToken(String token) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_TOKEN, token);
        this.addSecureHash(params);
        this.intercomApiInterface.deleteDeviceToken(params).enqueue((Callback)new Callback<UsersResponse.Builder>(){

            public void onResponse(Call<UsersResponse.Builder> call, io.intercom.retrofit2.Response<UsersResponse.Builder> response) {
            }

            public void onFailure(Call<UsersResponse.Builder> call, Throwable t) {
            }
        });
    }

    public void updateUser(Map<String, ?> attributes) {
        Map<String, Object> params = this.generateUpdateUserParams(DeviceData.generateDeviceData(this.context), false);
        params.put(USER_ATTRIBUTES, attributes);
        this.retriableUpdateUser(params, this.userIdentity.getFingerprint());
    }

    protected void retriableUpdateUser(final Map<String, Object> params, final String fingerprint) {
        this.intercomApiInterface.updateUser(params).enqueue((Callback)new BaseCallback<UpdateUserResponse.Builder>(){

            @Override
            public void onSuccess(UpdateUserResponse.Builder builder) {
                if (fingerprint.equals(Api.this.userIdentity.getFingerprint())) {
                    IntercomLogger.i("Successfully registered or updated user");
                    Api.this.callbacks.unreadCallback().onSuccess(builder);
                    Api.this.callbacks.teamPresenceCallback().onSuccess(builder);
                }
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Map user = (Map)params.get(Api.USER);
                if (Api.isUserNotFound(errorObject, user)) {
                    user.remove("intercom_id");
                    params.put(Api.USER, user);
                    Api.this.retriableUpdateUser(params, fingerprint);
                }
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Failed to register or update user", error);
            }
        });
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        eventParams.put("event_name", name);
        if (!metaData.isEmpty()) {
            eventParams.put("metadata", metaData);
        }
        params.put("event", eventParams);
        this.addSecureHash(params);
        this.intercomApiInterface.logEvent(params).enqueue(this.callbacks.unreadCallback());
    }

    public void markConversationAsRead(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.markAsRead(conversationId, params).enqueue(this.callbacks.readCallback());
        this.bus.post((Object)new ReadEvent(conversationId));
    }

    public void markConversationAsDismissed(String conversationId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("conversation_ids", new String[]{conversationId});
        this.addSecureHash(params);
        this.intercomApiInterface.markAsDismissed(params).enqueue((Callback)new Callback<Void>(){

            public void onResponse(Call<Void> call, io.intercom.retrofit2.Response<Void> response) {
            }

            public void onFailure(Call<Void> call, Throwable t) {
            }
        });
    }

    public void getInbox() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getInboxBefore(long before) {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("before", String.valueOf(before));
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getConversations(params).enqueue(this.callbacks.inboxCallback());
    }

    public void getUnreadConversations() {
        Map<String, Object> params = this.userIdentity.toMap();
        params.put("per_page", "20");
        this.addSecureHash(params);
        this.intercomApiInterface.getUnreadConversations(params).enqueue(this.callbacks.unreadCallback());
    }

    public void getConversation(String conversationId) {
        Map<String, Object> params = this.userIdentity.toMap();
        this.addSecureHash(params);
        this.intercomApiInterface.getConversation(conversationId, params).enqueue(this.callbacks.conversationCallback());
    }

    public void textReply(String conversationId, String messageText, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("body", messageText);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params).enqueue(this.callbacks.replyCallback(tempPartPosition, false, tempPartId, conversationId));
    }

    public void reactToConversation(String conversationId, int reactionIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put("reaction_index", reactionIndex);
        this.addSecureHash(params);
        this.intercomApiInterface.reactToConversation(conversationId, params).enqueue(this.callbacks.reactCallback());
    }

    public void attachmentReply(String conversationId, int uploadId, int tempPartPosition, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("type", USER);
        params.put("message_type", "comment");
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.replyToConversation(conversationId, params).enqueue(this.callbacks.replyCallback(tempPartPosition, true, tempPartId, conversationId));
    }

    public void startNewConversation(String messageText, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("body", messageText);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void startNewAttachmentConversation(int uploadId, int position, String tempPartId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", this.appIdentity.getAppId());
        params.put("upload_ids", new int[]{uploadId});
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.startNewConversation(params).enqueue(this.callbacks.newConversationCallback(position, tempPartId));
    }

    public void uploadFile(final AttachmentData data, final int tempPartPosition, final String tempPartId, final UploadingImageCache uploadingImageCache, final UploadProgressListener listener) {
        final String originalFileName = data.getFileName();
        final String mimeType = data.getMimeType();
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        uploadMap.put("original_filename", originalFileName);
        uploadMap.put("size_in_bytes", data.getSize());
        uploadMap.put("content_type", mimeType);
        uploadMap.put("width", data.getImageWidth());
        uploadMap.put("height", data.getImageHeight());
        params.put(UPLOAD, uploadMap);
        params.put(USER, this.userIdentity.toMap());
        this.addSecureHash(params);
        this.intercomApiInterface.uploadFile(params).enqueue((Callback)new BaseCallback<Upload.Builder>(){

            @Override
            public void onSuccess(Upload.Builder builder) {
                final Upload uploadResponse = builder.build();
                uploadingImageCache.put(uploadResponse, data);
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("key", uploadResponse.getKey()).addFormDataPart("acl", uploadResponse.getAcl()).addFormDataPart("Content-Type", uploadResponse.getContentType()).addFormDataPart("AWSAccessKeyId", uploadResponse.getAwsAccessKey()).addFormDataPart("policy", uploadResponse.getPolicy()).addFormDataPart("signature", uploadResponse.getSignature()).addFormDataPart("success_action_status", uploadResponse.getSuccessActionStatus()).addFormDataPart("file", originalFileName, (RequestBody)new ProgressRequestBody(MediaType.parse((String)mimeType), data.getFile(), listener)).build();
                Api.this.httpClient.newCall(new Request.Builder().url(uploadResponse.getUploadDestination()).post((RequestBody)requestBody).build()).enqueue(new io.intercom.okhttp3.Callback(){

                    public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                        IntercomLogger.e("Upload failed: " + e.getMessage());
                        Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                    }

                    public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                        IntercomLogger.internal("API Success", "Successfully uploaded");
                        if (response.isSuccessful()) {
                            Api.this.bus.post((Object)new UploadEvent(uploadResponse.getId(), tempPartPosition, tempPartId));
                        } else {
                            IntercomLogger.e("Upload failed: request body " + response.body());
                            Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
                        }
                        response.body().close();
                    }
                });
                IntercomLogger.internal("API Success", "Successfully uploaded");
            }

            @Override
            public void onError(ErrorObject errorObject) {
                Api.this.bus.post((Object)new UploadFailedEvent(tempPartPosition, tempPartId));
            }

            @Override
            void logFailure(String reason, ErrorObject error) {
                super.logFailure("Upload failed", error);
            }
        });
    }

    public void sendMetrics(List<MetricObject> metrics, Callback<Void> callback) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("metrics", metrics);
        this.intercomApiInterface.sendMetrics(params).enqueue(callback);
    }

    public void getVideo(String url, io.intercom.okhttp3.Callback callback) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(callback);
    }

    public void hitTrackingUrl(String url) {
        this.httpClient.newCall(new Request.Builder().url(url).build()).enqueue(new io.intercom.okhttp3.Callback(){

            public void onFailure(io.intercom.okhttp3.Call call, IOException e) {
                IntercomLogger.internal("Tracking Url", "Failed tracking url request");
            }

            public void onResponse(io.intercom.okhttp3.Call call, Response response) throws IOException {
                IntercomLogger.internal("Tracking Url", "success");
                response.body().close();
            }
        });
    }

    protected static boolean isUserNotFound(ErrorObject error, Map userParams) {
        if (error.hasErrorBody() && error.getStatusCode() == 404 && userParams != null && userParams.get("intercom_id") != null && userParams.size() > 1) {
            try {
                JSONObject errorObject = new JSONObject(error.getErrorBody());
                if (errorObject.getJSONArray("errors").getJSONObject(0).getString("code").equals("not_found")) {
                    return true;
                }
            }
            catch (Exception ignored) {
                IntercomLogger.internal("Could not parse error response");
            }
        }
        return false;
    }

    private void addSecureHash(Map<String, Object> params) {
        String secureData = this.userIdentity.getData();
        String secureHmac = this.userIdentity.getHmac();
        if (!TextUtils.isEmpty((CharSequence)secureData) && !TextUtils.isEmpty((CharSequence)secureHmac)) {
            params.put(DATA, secureData);
            params.put(HMAC, secureHmac);
        }
    }

    private Map<String, Object> generateUpdateUserParams(Map<String, Object> deviceData, boolean newSession) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(USER, this.userIdentity.toMap());
        params.put(DEVICE_DATA, deviceData);
        params.put(NEW_SESSION, newSession);
        this.addSecureHash(params);
        return params;
    }

    protected boolean isSynchronous() {
        return this.apiHttpClient.dispatcher().getMaxRequests() == 1;
    }

    public static interface Provider {
        public Api getApi();
    }
}

