package io.intercom.android.sdk.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.VisibleForTesting;

import java.util.ArrayList;
import java.util.List;

import io.intercom.android.sdk.logger.IntercomLogger;

public class IntercomNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;

    @VisibleForTesting final List<PushNotification> notifications = new ArrayList<>();

    private final IntercomNotificationFactory notificationFactory = new IntercomNotificationFactory();
    private final NotificationManager notificationManager;

    public IntercomNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void killNotifications() {
        if (!notifications.isEmpty()) {
            IntercomLogger.i("Removing Intercom FCM messages.");
        }

        notificationManager.cancel(NOTIFICATION_ID);
        notifications.clear();
    }

    void createPushOnlyNotification(PushNotification pushNotification, Context context) {
        Notification notification = notificationFactory.createPushOnlyNotification(pushNotification, context);
        String pushOnlyConversationId = pushNotification.getPushOnlyConversationId();
        notificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
    }

    void createNotification(PushNotification pushNotification, Context context) {
        notifications.add(pushNotification);

        Notification notification;

        if (notifications.size() == 1) {
            notification = notificationFactory.createSingleNotification(notifications.get(0), context);
        } else {
            notification = notificationFactory.createGroupedNotification(notifications, context);
        }

        notificationManager.notify(NOTIFICATION_ID, notification);
    }
}
