/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.Overlay;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.FontUtils;

abstract class ChatOverlay
extends Overlay {
    private static final int ANIMATION_DURATION = 170;
    private static final int GROWTH_WIDTH = 355;

    protected ChatOverlay(Context localisedContext, @NonNull Conversation conversation, int position, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(localisedContext, conversation, position, screenHeight, previewCallbacks);
    }

    protected abstract ViewGroup inflateChatRootView(ViewGroup var1, LayoutInflater var2);

    protected abstract View getContentContainer();

    protected abstract void updateContentContainer(Part var1);

    @Override
    protected abstract void updateViewDataDuringReplyPulse();

    @Override
    public void display(ViewGroup parentRoot, LayoutInflater inflater, boolean withFullAnimation) {
        if (this.overlayRoot == null) {
            this.overlayRoot = this.inflateChatRootView(parentRoot, inflater);
        }
        if (!this.isAttached()) {
            parentRoot.addView((View)this.overlayRoot, 0);
        }
        this.populateViewsWithData();
        if (withFullAnimation) {
            this.performEntranceAnimation();
        } else {
            this.overlayRoot.setVisibility(0);
            this.beginListeningForTouchEvents();
        }
    }

    @Override
    protected void onPreviewPressed(View view) {
        view.animate().scaleX(0.9f).scaleY(0.9f).alpha(0.9f).setDuration(50L).start();
    }

    @Override
    protected void onPreviewReleased(View view) {
        view.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(50L).start();
    }

    @Override
    public void moveBackward(ViewGroup rootView, AnimatorListenerAdapter animationListener) {
        ++this.position;
        this.animateToPosition(rootView.getContext());
        this.expandChat(rootView, animationListener);
    }

    private void populateViewsWithData() {
        View chatRootView = this.overlayRoot.findViewById(R.id.chathead_root);
        ImageView avatarView = (ImageView)chatRootView.findViewById(R.id.chathead_avatar);
        TextView headerTextView = (TextView)chatRootView.findViewById(R.id.chathead_text_header);
        headerTextView.setTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        FontUtils.setRobotoMediumTypeface(headerTextView);
        AvatarUtils.loadAvatarIntoView(this.conversation.getLastAdmin().getAvatar(), avatarView);
        headerTextView.setText(this.getHeaderText());
        Part lastPart = this.conversation.getLastPart();
        this.updateContentContainer(lastPart);
        IntercomLogger.internal("preview", "displayed preview");
    }

    private void performEntranceAnimation() {
        View avatarView = this.overlayRoot.findViewById(R.id.chat_avatar_container);
        final ViewGroup textContainerView = (ViewGroup)this.overlayRoot.findViewById(R.id.chat_full_body);
        textContainerView.setVisibility(4);
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)avatarView, (PropertyValuesHolder[])new PropertyValuesHolder[]{alpha}).setDuration(400L);
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ChatOverlay.this.animateTextContainer(textContainerView);
            }
        });
        objectAnimator.start();
    }

    private void animateTextContainer(ViewGroup textContainerView) {
        int startValue = (int)textContainerView.getX() - 150;
        int endValue = (int)textContainerView.getX();
        float propertiesStartValue = 0.8f;
        textContainerView.setScaleX(0.8f);
        textContainerView.setScaleY(0.8f);
        textContainerView.setAlpha(0.8f);
        textContainerView.setX((float)startValue);
        textContainerView.setVisibility(0);
        textContainerView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).scaleX(1.0f).scaleY(1.0f).alphaBy(1.0f).translationX((float)endValue).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ChatOverlay.this.beginListeningForTouchEvents();
            }
        }).start();
    }

    private void expandChat(ViewGroup rootView, AnimatorListenerAdapter animatorListener) {
        ViewGroup bubble = (ViewGroup)rootView.findViewById(R.id.chathead_text_container);
        if (bubble == null) {
            return;
        }
        TextView headerTextView = (TextView)rootView.findViewById(R.id.chathead_text_header);
        View bodyContent = this.getContentContainer();
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bubble.getLayoutParams();
        View avatarView = rootView.findViewById(R.id.chat_avatar_container);
        float translationX = avatarView.getTranslationX();
        float translationY = avatarView.getTranslationY();
        ObjectAnimator.ofPropertyValuesHolder((Object)avatarView, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{translationX, translationX + 100.0f}), PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{translationY, translationY - 40.0f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_X, (float[])new float[]{1.0f, 0.8f}), PropertyValuesHolder.ofFloat((Property)View.SCALE_Y, (float[])new float[]{1.0f, 0.8f})}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)headerTextView, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        ObjectAnimator.ofFloat((Object)bodyContent, (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(170L).start();
        this.getWidthAnimator(bubble, (Animator.AnimatorListener)animatorListener).start();
        this.getWidthAnimator(this.overlayRoot).start();
        this.getMarginAnimator(bubble, layoutParams).start();
    }

    private Animator getMarginAnimator(final ViewGroup bubble, FrameLayout.LayoutParams layoutParams) {
        int leftMargin = layoutParams.leftMargin;
        ValueAnimator animator2 = ValueAnimator.ofInt((int[])new int[]{leftMargin, 0});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int val = (Integer)animation.getAnimatedValue();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)bubble.getLayoutParams();
                layoutParams.leftMargin = val;
                bubble.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        animator2.setDuration(170L);
        return animator2;
    }

    private Animator getWidthAnimator(ViewGroup bubble, final Animator.AnimatorListener animatorListener) {
        final int diff = Math.abs(bubble.getMeasuredWidth() - ScreenUtils.dpToPx((float)355.0f, (Context)bubble.getContext()));
        ValueAnimator animator2 = this.getWidthAnimator(bubble);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            boolean hasSentUpdate = false;

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                int percentage = val / diff * 100;
                if (percentage > 80 && !this.hasSentUpdate) {
                    this.hasSentUpdate = true;
                    animatorListener.onAnimationEnd(null);
                }
            }
        });
        return animator2;
    }

    private ValueAnimator getWidthAnimator(final ViewGroup view) {
        int from = view.getMeasuredWidth();
        int to = ScreenUtils.dpToPx((float)355.0f, (Context)view.getContext());
        ValueAnimator animator2 = ValueAnimator.ofInt((int[])new int[]{from, to});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
                layoutParams.width = val;
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
        animator2.setDuration(170L);
        return animator2;
    }
}

