/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConversationList {
    private final List<Conversation> conversations;
    private final Set<String> unreadConversationIds;
    private final boolean morePagesAvailable;

    public ConversationList() {
        this(new Builder());
    }

    ConversationList(Builder builder) {
        this.conversations = new ArrayList<Conversation>(CollectionUtils.capacityFor(builder.conversations));
        if (builder.conversations != null) {
            for (Conversation.Builder conversationBuilder : builder.conversations) {
                this.conversations.add(conversationBuilder.build());
            }
        }
        this.unreadConversationIds = new HashSet<String>(CollectionUtils.capacityFor(builder.unread_conversation_ids));
        if (builder.unread_conversation_ids != null) {
            for (String id2 : builder.unread_conversation_ids) {
                if (id2 == null) continue;
                this.unreadConversationIds.add(id2);
            }
        }
        this.morePagesAvailable = builder.more_pages_available;
    }

    public List<Conversation> getConversations() {
        return this.conversations;
    }

    public Set<String> getUnreadConversationIds() {
        return this.unreadConversationIds;
    }

    public boolean hasMorePages() {
        return this.morePagesAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationList that = (ConversationList)o;
        if (this.morePagesAvailable != that.morePagesAvailable) {
            return false;
        }
        if (!this.conversations.equals(that.conversations)) {
            return false;
        }
        return this.unreadConversationIds.equals(that.unreadConversationIds);
    }

    public int hashCode() {
        int result = this.conversations.hashCode();
        result = 31 * result + this.unreadConversationIds.hashCode();
        result = 31 * result + (this.morePagesAvailable ? 1 : 0);
        return result;
    }

    public static final class Builder {
        List<Conversation.Builder> conversations;
        List<String> unread_conversation_ids;
        boolean more_pages_available;

        public ConversationList build() {
            return new ConversationList(this);
        }
    }
}

