/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.actions;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.state.ReplyPart;

public class Actions {
    private static final Object NONE = new Object();

    public static Action<BaseResponse> baseResponseReceived(BaseResponse response) {
        return new Action<BaseResponse>(Action.Type.BASE_RESPONSE_RECEIVED, response);
    }

    public static Action<?> reset() {
        return Actions.noValueAction(Action.Type.RESET);
    }

    public static Action<Conversation> newConversationSuccess(Conversation conversation) {
        return new Action<Conversation>(Action.Type.NEW_CONVERSATION_SUCCESS, conversation);
    }

    public static Action<?> inboxOpened() {
        return Actions.noValueAction(Action.Type.INBOX_OPENED);
    }

    public static Action<?> composerOpened() {
        return Actions.noValueAction(Action.Type.COMPOSER_OPENED);
    }

    public static Action<String> conversationOpened(String conversationId) {
        return new Action<String>(Action.Type.CONVERSATION_OPENED, conversationId);
    }

    public static Action<String> conversationMarkedAsRead(String conversationId) {
        return new Action<String>(Action.Type.CONVERSATION_MARKED_AS_READ, conversationId);
    }

    public static Action<UsersResponse> unreadConversationsSuccess(UsersResponse response) {
        return new Action<UsersResponse>(Action.Type.UNREAD_CONVERSATIONS_SUCCESS, response);
    }

    public static Action<?> fetchInboxStarted() {
        return Actions.noValueAction(Action.Type.FETCH_INBOX_STARTED);
    }

    public static Action<?> fetchInboxFailed() {
        return Actions.noValueAction(Action.Type.FETCH_INBOX_FAILED);
    }

    public static Action<ConversationsResponse> fetchInboxSuccess(ConversationsResponse response) {
        return new Action<ConversationsResponse>(Action.Type.FETCH_INBOX_SUCCESS, response);
    }

    public static Action<Conversation> fetchConversationSuccess(Conversation conversation) {
        return new Action<Conversation>(Action.Type.FETCH_CONVERSATION_SUCCESS, conversation);
    }

    public static Action<TeamPresence> teamPresenceUpdated(TeamPresence teamPresence) {
        return new Action<TeamPresence>(Action.Type.TEAM_PRESENCE_UPDATED, teamPresence);
    }

    public static Action<ReplyPart> conversationReplySuccess(ReplyPart replyPart) {
        return new Action<ReplyPart>(Action.Type.CONVERSATION_REPLY_SUCCESS, replyPart);
    }

    private static Action<?> noValueAction(Action.Type type) {
        return new Action<Object>(type, NONE);
    }
}

