/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import io.intercom.android.sdk.actions.Action;
import java.util.ArrayList;
import java.util.List;

public class Store<S> {
    private S currentState;
    private final Reducer<S> reducer;
    private final List<Runnable> subscribers = new ArrayList<Runnable>();
    private final Middleware<S> dispatcher = new Middleware<S>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(Store<S> store, Action<?> action, NextDispatcher next) {
            1 var4_4 = this;
            synchronized (var4_4) {
                Store.this.currentState = store.reducer.reduce(action, Store.this.currentState);
            }
            for (int i = 0; i < Store.this.subscribers.size(); ++i) {
                ((Runnable)store.subscribers.get(i)).run();
            }
        }
    };
    private final List<NextDispatcher> next = new ArrayList<NextDispatcher>();

    @SafeVarargs
    public Store(Reducer<S> reducer, S state, Middleware<S> ... middlewares) {
        this.reducer = reducer;
        this.currentState = state;
        this.next.add(new NextDispatcher(){

            @Override
            public void dispatch(Action<?> action) {
                Store.this.dispatcher.dispatch(Store.this, action, null);
            }
        });
        for (int i = middlewares.length - 1; i >= 0; --i) {
            final Middleware<S> mw = middlewares[i];
            final NextDispatcher n = this.next.get(0);
            this.next.add(0, new NextDispatcher(){

                @Override
                public void dispatch(Action<?> action) {
                    mw.dispatch(Store.this, action, n);
                }
            });
        }
    }

    public S dispatch(Action<?> action) {
        this.next.get(0).dispatch(action);
        return this.getState();
    }

    public S getState() {
        return this.currentState;
    }

    public Runnable subscribe(final Runnable r) {
        this.subscribers.add(r);
        return new Runnable(){

            @Override
            public void run() {
                Store.this.subscribers.remove(r);
            }
        };
    }

    public static interface NextDispatcher {
        public void dispatch(Action<?> var1);
    }

    public static interface Middleware<S> {
        public void dispatch(Store<S> var1, Action<?> var2, NextDispatcher var3);
    }

    public static interface Reducer<S> {
        public S reduce(Action<?> var1, S var2);
    }
}

