/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.NameUtils;

class NotificationAvatarUtils {
    private static final int LARGE_ICON_SIZE_DP = 48;

    NotificationAvatarUtils() {
    }

    public static Bitmap getNotificationInitialsBitmap(Context context, String name) {
        return NotificationAvatarUtils.drawableToBitmap(context, AvatarUtils.getInitialsDrawable(NameUtils.getInitial(name)));
    }

    public static Bitmap getNotificationDefaultBitmap(Context context) {
        return NotificationAvatarUtils.drawableToBitmap(context, AvatarUtils.getDefaultDrawable(context));
    }

    private static Bitmap drawableToBitmap(Context context, Drawable drawable2) {
        Bitmap bitmap;
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
            int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
            bitmap = Bitmap.createBitmap((int)iconSize, (int)iconSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

