/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.profile.ProfileCoordinator;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.profile.TeamProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.AvatarUtils;
import java.util.Arrays;
import java.util.List;

class TeamProfilePresenter {
    private final ViewGroup rootLayout;
    private final LinearLayout avatarLayout;
    private final ProfileToolbarBehavior toolbarBehavior;
    private final TextView collapsedToolbarTitle;
    private final TextView collapsedToolbarSubtitle;
    private final List<ImageView> avatarViews;
    private final List<TextView> adminNameViews;
    private final TextView bioView;
    private final ProfileCoordinator profileCoordinator;

    public TeamProfilePresenter(CoordinatorLayout rootView, @ColorInt int baseColor, ProfileCoordinator profileCoordinator) {
        this.profileCoordinator = profileCoordinator;
        this.rootLayout = (ViewGroup)rootView.findViewById(R.id.intercom_team_profile);
        this.rootLayout.setBackgroundColor(baseColor);
        this.rootLayout.setAlpha(0.0f);
        this.collapsedToolbarTitle = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_title);
        this.collapsedToolbarSubtitle = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_subtitle);
        this.avatarLayout = (LinearLayout)this.rootLayout.findViewById(R.id.intercom_team_profiles_layout);
        this.avatarViews = Arrays.asList((ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar1), (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar2), (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_avatar3));
        this.adminNameViews = Arrays.asList((TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_1), (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_2), (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_name_3));
        this.bioView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_team_bio);
        this.toolbarBehavior = new TeamProfileToolbarBehavior(this.rootLayout);
    }

    public ViewGroup getRootLayout() {
        return this.rootLayout;
    }

    public ProfileToolbarBehavior getToolbarBehavior() {
        return this.toolbarBehavior;
    }

    public void setPresence(TeamPresence teamPresence, int maxWidth, AppBarLayout appBarLayout, View teammateLayout, View titleLayoutCoordinator) {
        appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.toolbarBehavior);
        if (this.rootLayout.getAlpha() < 1.0f || this.avatarLayout.getVisibility() == 8) {
            teammateLayout.setAlpha(0.0f);
            this.rootLayout.setAlpha(1.0f);
            if (this.profileCoordinator.isDidShowUnknown()) {
                titleLayoutCoordinator.requestLayout();
                appBarLayout.setExpanded(true, true);
                this.profileCoordinator.setDidShowUnknown(false);
            }
        }
        if (teamPresence == null) {
            this.avatarLayout.setVisibility(8);
        } else {
            this.avatarLayout.setVisibility(0);
            List<Participant> admins = teamPresence.getActiveAdmins();
            this.collapsedToolbarSubtitle.setText((CharSequence)teamPresence.getExpectedResponseDelay());
            for (int i = 0; i < this.avatarViews.size() && i < admins.size(); ++i) {
                ImageView avatarView = this.avatarViews.get(i);
                TextView nameTextView = this.adminNameViews.get(i);
                Participant admin = admins.get(i);
                this.setAvatar(admin.getAvatar(), avatarView);
                avatarView.setVisibility(0);
                nameTextView.setText((CharSequence)admin.getForename());
                nameTextView.setVisibility(0);
            }
        }
        this.setProfileTextView(this.bioView, Injector.get().getAppIdentity().getAppConfig().getTeamProfileBio());
        Context context = this.rootLayout.getContext();
        if (maxWidth == 0) {
            maxWidth = ScreenUtils.getScreenDimensions((Context)context).x;
        }
        int originalMaxLines = 1;
        if (Build.VERSION.SDK_INT >= 16) {
            originalMaxLines = this.collapsedToolbarSubtitle.getMaxLines();
        }
        this.collapsedToolbarSubtitle.setMaxLines(5);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)0x40000000);
        this.rootLayout.measure(widthSpec, 0);
        titleLayoutCoordinator.getLayoutParams().height = this.rootLayout.getMeasuredHeight();
        Resources resources = context.getResources();
        this.rootLayout.getLayoutParams().height = resources.getDimensionPixelSize(R.dimen.intercom_toolbar_height);
        titleLayoutCoordinator.requestLayout();
        this.collapsedToolbarSubtitle.setMaxLines(originalMaxLines);
        this.rootLayout.requestLayout();
        this.profileCoordinator.applyOffsetChangedListener(this.toolbarBehavior);
    }

    private void setProfileTextView(TextView textView, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(0);
            textView.setText(text);
        }
    }

    private void setAvatar(Avatar avatar, ImageView imageView) {
        imageView.setVisibility(0);
        AvatarUtils.loadAvatarIntoView(avatar, imageView);
    }

    public void setTeamCollapsingTitle(@Nullable CharSequence title) {
        this.collapsedToolbarTitle.setText(title);
    }
}

