/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.TeamPresenceProvider;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxRowViewHolder;
import io.intercom.android.sdk.inbox.InboxStore;
import io.intercom.android.sdk.inbox.LoadingViewHolder;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.util.Locale;

class InboxAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int CONVERSATION = 0;
    private static final int LOADING = 1;
    private final InboxStore inboxStore;
    private final LayoutInflater inflater;
    private final ConversationClickListener conversationClickListener;
    private final TeamPresenceProvider teamPresenceProvider;
    private final TimeFormatter timeFormatter;

    public InboxAdapter(@NonNull Context context, @NonNull InboxStore inboxStore, @NonNull ConversationClickListener conversationClickListener, @NonNull TeamPresenceProvider teamPresenceProvider) {
        this.inflater = LayoutInflater.from((Context)context);
        this.inboxStore = inboxStore;
        this.conversationClickListener = conversationClickListener;
        this.teamPresenceProvider = teamPresenceProvider;
        this.timeFormatter = new TimeFormatter(context, Injector.get().getTimeProvider());
        this.setHasStableIds(true);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new InboxRowViewHolder(this.inflater.inflate(R.layout.intercom_row_inbox, parent, false), this.teamPresenceProvider, this.conversationClickListener, this.timeFormatter);
        }
        if (viewType == 1) {
            return new LoadingViewHolder(this.inflater.inflate(R.layout.intercom_row_loading, parent, false));
        }
        throw new RuntimeException(String.format(Locale.getDefault(), "View type %d not supported", viewType));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof InboxRowViewHolder) {
            InboxRowViewHolder viewHolder = (InboxRowViewHolder)holder;
            viewHolder.bindData(this.inboxStore.get(position));
        }
    }

    public int getItemCount() {
        return this.inboxStore.size();
    }

    public int getItemViewType(int position) {
        return this.inboxStore.get(position) instanceof Conversation.Loading ? 1 : 0;
    }

    public long getItemId(int position) {
        String id2 = this.inboxStore.get(position).getId();
        long result = !TextUtils.isEmpty((CharSequence)id2) && TextUtils.isDigitsOnly((CharSequence)id2) ? Long.valueOf(id2) : (long)id2.hashCode();
        return result;
    }
}

