/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.FontUtils;

public abstract class IntercomErrorView
extends RelativeLayout {
    private final TextView title;
    private final TextView subtitle;
    private final Button actionButton;

    public IntercomErrorView(Context context) {
        this(context, null);
    }

    public IntercomErrorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(this.getLayoutRes(), (ViewGroup)this, true);
        this.title = (TextView)this.findViewById(R.id.empty_text_title);
        FontUtils.setTypeface(context, this.title, "intercom_roboto_medium.ttf");
        this.subtitle = (TextView)this.findViewById(R.id.empty_text_subtitle);
        this.actionButton = (Button)this.findViewById(R.id.action_button);
        if (!this.isInEditMode()) {
            this.actionButton.setTextColor(Injector.get().getAppIdentity().getAppConfig().getBaseColor());
        }
    }

    public void setTitle(String title) {
        this.title.setText((CharSequence)title);
    }

    public void setTitle(@StringRes int title) {
        this.title.setText(title);
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.setText((CharSequence)subtitle);
    }

    public void setSubtitle(@StringRes int subtitle) {
        this.subtitle.setText(subtitle);
    }

    public void setActionButtonVisibility(int visibility) {
        this.actionButton.setVisibility(visibility);
    }

    public void setActionButtonText(@StringRes int text) {
        this.actionButton.setText(text);
    }

    public void setActionButtonClickListener(@Nullable View.OnClickListener onClickListener) {
        this.actionButton.setOnClickListener(onClickListener);
    }

    @LayoutRes
    public abstract int getLayoutRes();
}

