/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.preview.ChatOverlay;
import io.intercom.android.sdk.preview.PreviewCallbacks;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.com.facebook.rebound.SpringSystem;

public class ChatSnippet
extends ChatOverlay {
    private TextView contentBody;

    public ChatSnippet(Context context, Conversation conversation, int position, SpringSystem springSystem, int screenHeight, PreviewCallbacks previewCallbacks) {
        super(context, conversation, position, springSystem, screenHeight, previewCallbacks);
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parentRoot, LayoutInflater inflater) {
        ViewGroup chatRoot = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_overlay, parentRoot, false);
        this.contentBody = (TextView)inflater.inflate(R.layout.intercom_preview_chat_snippet_body, chatRoot, false);
        ((ViewGroup)chatRoot.findViewById(R.id.chathead_text_container)).addView((View)this.contentBody);
        return chatRoot;
    }

    @Override
    protected void updateContentContainer(Part part) {
        this.setBodyText(part);
    }

    @Override
    protected View getContentContainer() {
        return this.overlayRoot.findViewById(R.id.chathead_text_body);
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View text = this.overlayRoot.findViewById(R.id.chathead_text_body);
        View textContainer = this.overlayRoot.findViewById(R.id.chathead_text_container);
        textContainer.setPivotX(0.0f);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse() {
        ImageView avatarView = (ImageView)this.overlayRoot.findViewById(R.id.chathead_avatar);
        AvatarUtils.createAvatar(this.conversation.getLastAdmin().getAvatar(), avatarView, this.overlayRoot.getContext());
        TextView headerTextView = (TextView)this.overlayRoot.findViewById(R.id.chathead_text_header);
        headerTextView.setText((CharSequence)this.getHeaderText(headerTextView.getContext()));
        Part lastPart = this.conversation.getLastPart();
        this.setBodyText(lastPart);
    }

    private void setBodyText(Part part) {
        if (!part.getSummary().isEmpty()) {
            this.contentBody.setText((CharSequence)part.getSummary());
        } else {
            this.contentBody.setText(R.string.intercomsdk_image_attached);
        }
    }
}

