/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Handler;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.VideoProvider;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.okhttp3.Call;
import io.intercom.okhttp3.Callback;
import io.intercom.okhttp3.Response;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Video
implements VideoBlock {
    private final LayoutInflater inflater;
    private final Context context;
    private final StyleType style;

    public Video(Context context, LayoutInflater inflater, StyleType style) {
        this.context = context;
        this.style = style;
        this.inflater = inflater;
    }

    public View addVideo(String videoUrl, VideoProvider provider, final String id2, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        RelativeLayout rootView = (RelativeLayout)this.inflater.inflate(R.layout.intercom_blocks_video, parent, false);
        final ImageView imageView = (ImageView)rootView.findViewById(R.id.video_block_image);
        final ImageView playButton = (ImageView)rootView.findViewById(R.id.play_button);
        final View blackOverlay = rootView.findViewById(R.id.transparent_black_overlay);
        int color2 = Injector.get().getIdentityStore().getAppConfig().getBaseColor();
        if (this.style == StyleType.POST) {
            color2 = ColorUtils.lightenColor(color2);
        }
        playButton.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        switch (provider) {
            case WISTIA: {
                Injector.get().getApi().getVideo("http://fast.wistia.com/oembed?url=http://home.wistia.com/medias/" + id2, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(imageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            final String wistiaVideoUrl = "http://fast.wistia.net/embed/iframe/" + id2;
                            JSONObject video = new JSONObject();
                            try {
                                video = new JSONObject(response.body().string());
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                            }
                            finally {
                                response.body().close();
                            }
                            String wistiaThumbnailUrl = video.optString("thumbnail_url");
                            int end = wistiaThumbnailUrl.indexOf("?image_crop_resized");
                            if (end > 0) {
                                wistiaThumbnailUrl = wistiaThumbnailUrl.substring(0, end);
                            }
                            Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                            final String finalWistiaThumbnailUrl = wistiaThumbnailUrl;
                            Runnable myRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(imageView, wistiaVideoUrl, finalWistiaThumbnailUrl, playButton, blackOverlay);
                                }
                            };
                            mainHandler.post(myRunnable);
                        } else {
                            Video.this.setFailedImage(imageView);
                        }
                    }
                });
                break;
            }
            case YOUTUBE: {
                this.createThumbnail(imageView, "http://www.youtube.com/watch?v=" + id2, "http://img.youtube.com/vi/" + id2 + "/default.jpg", playButton, blackOverlay);
                break;
            }
            case VIMEO: {
                String vimeoVideoUrl = "http://vimeo.com/api/v2/video/" + id2 + ".json";
                Injector.get().getApi().getVideo(vimeoVideoUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(imageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            JSONObject video = new JSONObject();
                            try {
                                JSONArray jArray = new JSONArray(response.body().string());
                                video = jArray.optJSONObject(0);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                            }
                            finally {
                                response.body().close();
                            }
                            final String vimeoThumbnailUrl = video.optString("thumbnail_large");
                            Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                            Runnable myRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(imageView, "http://player.vimeo.com/video/" + id2, vimeoThumbnailUrl, playButton, blackOverlay);
                                }
                            };
                            mainHandler.post(myRunnable);
                        }
                    }
                });
                break;
            }
        }
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, 3, isLastObject);
        return rootView;
    }

    private void createThumbnail(ImageView imageView, final String videoUrl, String thumbnailUrl, final ImageView playButton, final View blackOverlay) {
        Glide.with((Context)this.context).load(thumbnailUrl).placeholder(R.drawable.intercom_video_thumbnail_fallback).error(R.drawable.intercom_video_thumbnail_fallback).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                blackOverlay.setVisibility(8);
                playButton.setVisibility(8);
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                blackOverlay.setVisibility(0);
                playButton.setVisibility(0);
                return false;
            }
        }).into(imageView);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Uri uri = Uri.parse((String)videoUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setFlags(0x10000000);
                IntentUtils.safelyOpenIntent(Video.this.context, intent);
            }
        });
    }

    private void setFailedImage(final ImageView imageView) {
        imageView.post(new Runnable(){

            @Override
            public void run() {
                BackgroundUtils.setBackground((View)imageView, ContextCompat.getDrawable((Context)Video.this.context, (int)R.drawable.intercom_video_thumbnail_fallback));
            }
        });
    }
}

