/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IamActivity;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomNoteActivity
extends AppCompatActivity
implements IntercomToolbar.Listener,
View.OnClickListener {
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String LAST_PARTICIPANT = "last_participant";
    private Part part;
    private LastParticipatingAdmin lastParticipatingAdmin;
    private String conversationId;
    private LinearLayout noteLayout;
    private ReactionInputView reactionComposer;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_note);
        this.noteLayout = (LinearLayout)this.findViewById(R.id.note_layout);
        this.noteLayout.setVisibility(4);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        IntercomToolbar intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        intercomToolbar.setListener(this);
        intercomToolbar.setBackgroundColor(Injector.get().getIdentityStore().getAppConfig().getBaseColor());
        Bundle data = this.getIntent().getExtras();
        this.part = new Part();
        if (data != null) {
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                if (this.part != null) {
                    intercomToolbar.setTitle(this.part.getParticipant().getForename());
                }
                intercomToolbar.setSubtitle(String.format(this.getResources().getString(R.string.intercom_from_company), Injector.get().getIdentityStore().getAppConfig().getName()));
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID);
                Injector.get().getUnreadCountTracker().decrementCount();
                Injector.get().getApi().markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        intercomToolbar.setUpNoteToolbar(this.part.getParticipant().getAvatar());
        ViewHolderGenerator.createPartUi(new ViewHolderGenerator((Context)this).getNoteHolder(), this.part, (Context)this);
        ScrollView noteView = (ScrollView)this.findViewById(R.id.note_view);
        noteView.addView(BlockUtils.getBlockView((ViewGroup)noteView, this.part.getLayout(), (Context)this));
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.getWindow().getDecorView(), (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (ReactionReply.isNull(IntercomNoteActivity.this.part.getReactionReply())) {
                    View touchTarget = IntercomNoteActivity.this.findViewById(R.id.note_touch_target);
                    touchTarget.setOnClickListener((View.OnClickListener)IntercomNoteActivity.this);
                    IntercomNoteActivity.this.findViewById(R.id.composer_input_view).setVisibility(0);
                } else {
                    IntercomNoteActivity.this.reactionComposer.setUpReactions(IntercomNoteActivity.this.part.getReactionReply(), IntercomNoteActivity.this.conversationId, true);
                }
                IntercomNoteActivity.this.animateContent();
            }
        });
        animator2.start();
    }

    private void animateContent() {
        this.noteLayout.setScaleX(0.9f);
        this.noteLayout.setScaleY(0.9f);
        this.noteLayout.setAlpha(0.0f);
        this.noteLayout.setVisibility(0);
        this.noteLayout.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration(200L).start();
    }

    private void closeNote() {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)this.getWindow().getDecorView(), (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        animator2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomNoteActivity.this.finish();
                IntercomNoteActivity.this.overridePendingTransition(0, 0);
            }
        });
        animator2.start();
    }

    public static Intent buildNoteIntent(@NonNull Context context, @NonNull Part part, @NonNull String conversationId, @NonNull LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomNoteActivity.class);
        intent.putExtra(PARCEL_PART, (Parcelable)part);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        intent.setFlags(0x10000000);
        return intent;
    }

    public void onBackPressed() {
        this.closeNote();
        Injector.get().getMetricsStore().track(MetricFactory.dismissedFullInApp(this.conversationId, this.part.getMessageStyle()));
    }

    @Override
    public void onCloseClicked() {
        this.onBackPressed();
    }

    @Override
    public void onInboxClicked() {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.note_touch_target) {
            this.closeNote();
            Intent conversationIntent = IamActivity.openConversationFull((Context)this, this.conversationId, this.lastParticipatingAdmin);
            this.startActivity(conversationIntent);
            Injector.get().getMetricsStore().track(MetricFactory.tappedOnFullInApp(this.conversationId, this.part.getMessageStyle()));
        }
    }
}

