/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Vibrator;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MotionEventCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.Reaction;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;
import io.intercom.com.facebook.rebound.SpringSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReactionInputView
extends LinearLayout
implements View.OnTouchListener {
    private static final int SPRING_TENSION = 600;
    private static final int SPRING_FRICTION = 40;
    private static final int REACTION_SPRING_TENSION = 1000;
    private static final int REACTION_SPRING_FRICTION = 36;
    private static final double REACTION_SCALE = 2.5;
    private static final int VIBRATION_DURATION_MS = 10;
    private final List<Spring> reactionSprings = new ArrayList<Spring>();
    private final List<ImageView> reactionViews = new ArrayList<ImageView>();
    private final LongTermImageLoader longTermImageLoader;
    private final Vibrator vibrator;
    private String conversationId = "";
    private Integer highlightedViewIndex = null;
    private int reactionsLoaded = 0;
    private ReactionReply reactionReply;

    public ReactionInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ReactionInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        if (this.isInEditMode()) {
            this.longTermImageLoader = null;
            this.vibrator = null;
        } else {
            this.longTermImageLoader = LongTermImageLoader.newInstance(context);
            this.vibrator = (Vibrator)context.getSystemService("vibrator");
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnTouchListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.setOnTouchListener(null);
        if (!this.isInEditMode()) {
            try {
                this.longTermImageLoader.close();
            }
            catch (IOException e) {
                IntercomLogger.d("Couldn't close LongTermImageLoader: " + e.getMessage());
            }
        }
    }

    public void setUpReactions(ReactionReply reactionReply, String conversationId, final boolean animated) {
        final Context context = this.getContext();
        this.reactionReply = reactionReply;
        this.conversationId = conversationId;
        List<Reaction> reactionSet = reactionReply.getReactionSet();
        final int reactionCount = reactionSet.size();
        final SpringSystem springSystem = SpringSystem.create();
        for (int i = 0; i < reactionSet.size(); ++i) {
            FrameLayout frameLayout = new FrameLayout(context);
            LinearLayout.LayoutParams frameParams = new LinearLayout.LayoutParams(0, -1);
            frameParams.weight = 1.0f;
            frameLayout.setClipChildren(false);
            frameLayout.setClipToPadding(false);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)frameParams);
            final ImageView reactionImageView = new ImageView(context);
            int reactionSizePx = this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_size);
            FrameLayout.LayoutParams imageParams = new FrameLayout.LayoutParams(reactionSizePx, reactionSizePx);
            imageParams.gravity = 17;
            reactionImageView.setLayoutParams((ViewGroup.LayoutParams)imageParams);
            reactionImageView.setPivotY((float)this.getResources().getDimensionPixelSize(R.dimen.intercom_reaction_offset));
            reactionImageView.setPivotX((float)(reactionSizePx / 2));
            this.reactionViews.add(reactionImageView);
            frameLayout.addView((View)reactionImageView);
            Reaction reaction = reactionSet.get(i);
            this.longTermImageLoader.loadImage(reaction.getImageUrl(), this.getContext(), new LongTermImageLoader.OnImageReadyListener(){

                @Override
                public void onImageReady(Bitmap bitmap) {
                    reactionImageView.setImageBitmap(bitmap);
                    ReactionInputView.this.reactionsLoaded++;
                    if (ReactionInputView.this.reactionsLoaded == reactionCount) {
                        if (animated) {
                            Spring spring = springSystem.createSpring();
                            SpringConfig springConfig = new SpringConfig(600.0, 40.0);
                            spring.setSpringConfig(springConfig);
                            double startY = ReactionInputView.this.getY();
                            spring.setCurrentValue((double)(ReactionInputView.this.getY() + (float)ReactionInputView.this.getHeight() + (float)ScreenUtils.convertDpToPixel((float)60.0f, (Context)context)));
                            spring.setEndValue(startY);
                            spring.addListener((SpringListener)new SimpleSpringListener(){

                                public void onSpringActivate(Spring spring) {
                                    ReactionInputView.this.setVisibility(0);
                                }

                                public void onSpringUpdate(Spring spring) {
                                    float value = (float)spring.getCurrentValue();
                                    ReactionInputView.this.setY(value);
                                }
                            });
                        } else {
                            ReactionInputView.this.setVisibility(0);
                        }
                    }
                }
            });
            Spring spring = springSystem.createSpring();
            SpringConfig springConfig = new SpringConfig(1000.0, 36.0);
            spring.setSpringConfig(springConfig);
            this.reactionSprings.add(spring);
            spring.setCurrentValue(1.0);
            spring.addListener((SpringListener)new SimpleSpringListener(){

                public void onSpringUpdate(Spring spring) {
                    float value = (float)spring.getCurrentValue();
                    reactionImageView.setScaleX(value);
                    reactionImageView.setScaleY(value);
                }
            });
            Integer selectedReactionIndex = reactionReply.getReactionIndex();
            if (selectedReactionIndex != null && !selectedReactionIndex.equals(reaction.getIndex())) {
                this.deselectViewAtIndex(i);
            }
            this.addView((View)frameLayout);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        switch (action) {
            case 0: 
            case 2: {
                this.handleTouchMove(event);
                break;
            }
            case 1: {
                this.handleTouchUp();
            }
        }
        return true;
    }

    private void handleTouchMove(MotionEvent event) {
        Rect rootRect = new Rect();
        this.getHitRect(rootRect);
        if (rootRect.contains((int)event.getX(), (int)event.getY())) {
            Rect reactionRect = new Rect();
            for (int i = 0; i < this.getChildCount(); ++i) {
                this.getChildAt(i).getHitRect(reactionRect);
                if (reactionRect.contains((int)event.getX(), (int)event.getY())) {
                    if (this.highlightedViewIndex == null || this.highlightedViewIndex != i) {
                        this.vibrateForSelection();
                        this.selectViewAtIndex(2.5, i);
                    }
                    this.highlightedViewIndex = i;
                    continue;
                }
                this.deselectViewAtIndex(i);
            }
        } else {
            this.highlightedViewIndex = null;
            this.highlightSelectedReaction();
        }
    }

    private void vibrateForSelection() {
        if (DeviceUtils.hasPermission((Context)this.getContext(), (String)"android.permission.VIBRATE")) {
            this.vibrator.vibrate(10L);
        }
    }

    private void handleTouchUp() {
        Reaction selectedReaction;
        if (this.highlightedViewIndex != null && this.highlightedViewIndex >= 0 && this.highlightedViewIndex < this.reactionReply.getReactionSet().size() && (selectedReaction = this.reactionReply.getReactionSet().get(this.highlightedViewIndex)) != null && (this.reactionReply.getReactionIndex() == null || selectedReaction.getIndex() != this.reactionReply.getReactionIndex().intValue())) {
            this.reactionReply.setReactionIndex(selectedReaction.getIndex());
            Injector.get().getApi().reactToConversation(this.conversationId, selectedReaction.getIndex());
            Injector.get().getMetricsStore().track(MetricFactory.sentReactionMessage(this.conversationId));
        }
        this.highlightSelectedReaction();
        this.highlightedViewIndex = null;
    }

    private void highlightSelectedReaction() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Integer selectedReactionIndex = this.reactionReply.getReactionIndex();
            if (selectedReactionIndex == null || selectedReactionIndex.equals(this.reactionReply.getReactionSet().get(i).getIndex())) {
                this.selectViewAtIndex(1.0, i);
                continue;
            }
            this.deselectViewAtIndex(i);
        }
    }

    private void selectViewAtIndex(double scale, int index) {
        ImageView reactionImage;
        Spring spring = this.reactionSprings.get(index);
        if (spring.getEndValue() != scale) {
            spring.setAtRest();
            spring.setEndValue(scale);
        }
        if ((reactionImage = this.reactionViews.get(index)) != null) {
            reactionImage.clearColorFilter();
        }
    }

    private void deselectViewAtIndex(int index) {
        ImageView reactionImage;
        Spring spring = this.reactionSprings.get(index);
        if (spring.getEndValue() != 1.0) {
            spring.setAtRest();
            spring.setEndValue(1.0);
        }
        if ((reactionImage = this.reactionViews.get(index)) != null) {
            reactionImage.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_reaction_filter));
        }
    }
}

