/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.MainThreadBus;
import io.intercom.android.sdk.api.PollingManager;
import io.intercom.android.sdk.identity.IdentityStore;
import io.intercom.android.sdk.lifecycles.Lifecycles;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.preview.PreviewDisplayManager;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;

@TargetApi(value=14)
public class Bridge {
    private static Bridge instance;
    private final PollingManager poller;
    private final MainThreadBus bus;
    private final Api api;
    private final IdentityStore identityStore;
    private final MetricsStore metricsStore;
    private final Context appContext;
    private final NexusWrapper nexusClient;
    private final PreviewManager previewManager;
    private final DeDuper superDeDuper;

    private Bridge(Application application) {
        this.appContext = application.getApplicationContext();
        this.poller = new PollingManager();
        this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        this.superDeDuper = new DeDuper();
        this.nexusClient = new NexusWrapper();
        this.identityStore = new IdentityStore(this.appContext);
        this.metricsStore = new MetricsStore(this.appContext);
        this.api = new Api(this.appContext, !this.identityStore.hasIntercomid());
        Lifecycles lifecycles = new Lifecycles(this.superDeDuper);
        this.previewManager = new PreviewManager(application, this.bus, this.poller, new PreviewDisplayManager());
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifecycles);
        this.nexusClient.setLoggingEnabled(false);
    }

    public static synchronized void init(Application application) {
        if (instance == null) {
            IntercomLogger.INTERNAL("bridge", "initialising bridge");
            instance = new Bridge(application);
        }
    }

    public static Api getApi() {
        return instance.api();
    }

    public static Bus getBus() {
        return Bridge.instance.bus;
    }

    public static PollingManager getPoller() {
        return Bridge.instance.poller;
    }

    public static IdentityStore getIdentityStore() {
        return Bridge.instance.identityStore;
    }

    public static MetricsStore getMetricsStore() {
        return Bridge.instance.metricsStore;
    }

    public static NexusWrapper getNexusClient() {
        return Bridge.instance.nexusClient;
    }

    public static Context getContext() {
        return Bridge.instance.appContext;
    }

    public static PreviewManager getPreviewManager() {
        return Bridge.instance.previewManager;
    }

    public static DeDuper getDeDuper() {
        return Bridge.instance.superDeDuper;
    }

    private Api api() {
        this.api.configureRequestSynchronicity(this.appContext, this.identityStore.hasIntercomid());
        return this.api;
    }
}

