/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import java.util.ArrayList;
import java.util.List;

public class NexusSdkConfig {
    private final List<String> endpoints;
    private final int presenceHeartbeatInterval;
    private final int connectionTimeout;

    public NexusSdkConfig() {
        this(new Builder());
    }

    public NexusSdkConfig(Builder builder) {
        this.endpoints = builder.endpoints == null ? new ArrayList() : builder.endpoints;
        this.presenceHeartbeatInterval = builder.presence_heartbeat_interval;
        this.connectionTimeout = builder.connection_timeout;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public int getPresenceHeartbeatInterval() {
        return this.presenceHeartbeatInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NexusSdkConfig that = (NexusSdkConfig)o;
        return this.connectionTimeout == that.connectionTimeout && this.presenceHeartbeatInterval == that.presenceHeartbeatInterval && this.endpoints.equals(that.endpoints);
    }

    public int hashCode() {
        int result = this.endpoints.hashCode();
        result = 31 * result + this.presenceHeartbeatInterval;
        result = 31 * result + this.connectionTimeout;
        return result;
    }

    public static class Builder {
        private List<String> endpoints;
        private int presence_heartbeat_interval;
        private int connection_timeout;

        public NexusSdkConfig build() {
            return new NexusSdkConfig(this);
        }

        public Builder withEndpoints(List<String> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder WithPresenceHeartbeatInterval(int presence_heartbeat_interval) {
            this.presence_heartbeat_interval = presence_heartbeat_interval;
            return this;
        }

        public Builder withConnectionTimeout(int connection_timeout) {
            this.connection_timeout = connection_timeout;
            return this;
        }
    }
}

