/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class NexusAppConfig {
    private final List<String> endpoints = new ArrayList<String>();
    private final String publishKey;
    private final String subscribeKey;
    private final String channel;
    private final boolean isValidConfig;

    public NexusAppConfig() {
        this(new Builder());
    }

    public NexusAppConfig(Builder builder) {
        if (builder.endpoints != null) {
            for (String endpoint : builder.endpoints) {
                if (TextUtils.isEmpty((CharSequence)endpoint)) continue;
                this.endpoints.add(endpoint);
            }
        }
        this.publishKey = builder.publish_key == null ? "" : builder.publish_key;
        this.subscribeKey = builder.subscribe_key == null ? "" : builder.subscribe_key;
        this.channel = builder.channel == null ? "" : builder.channel;
        this.isValidConfig = !this.channel.isEmpty() && !this.subscribeKey.isEmpty() && !this.publishKey.isEmpty();
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public String getPublishKey() {
        return this.publishKey;
    }

    public String getSubscribeKey() {
        return this.subscribeKey;
    }

    public String getChannel() {
        return this.channel;
    }

    public boolean isValidConfig() {
        return this.isValidConfig;
    }

    public static class Builder {
        private List<String> endpoints;
        private String publish_key;
        private String subscribe_key;
        private String channel;

        public NexusAppConfig build() {
            return new NexusAppConfig(this);
        }
    }
}

