/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.os.Handler;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Lifecycles;
import io.intercom.android.sdk.logger.IntercomLogger;
import java.util.concurrent.TimeUnit;

public class PollingManager {
    private final Handler handler = new Handler();
    private final Handler conversationHandler = new Handler();
    private final Runnable previewPoller = new Runnable(){

        @Override
        public void run() {
            IntercomLogger.INTERNAL("polling", "chathead poll");
            Bridge.getApi().getUnreadConversations();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.previewPoller);
        }
    };
    private final Runnable inboxPoller = new Runnable(){

        @Override
        public void run() {
            IntercomLogger.INTERNAL("polling", "inbox poll");
            Bridge.getApi().getInbox();
            PollingManager.this.poll(PollingManager.this.handler, PollingManager.this.inboxPoller);
        }
    };
    private Runnable conversationPoller;
    private boolean currentlyThrottlingInboxPoll;
    private boolean currentlyThrottlingConversationPoll;
    private boolean currentlyThrottlingPreviewPoll;

    public void startConversationPolling(final String conversationId) {
        IntercomLogger.INTERNAL("polling", "starting conversation polling");
        this.conversationPoller = new Runnable(){

            @Override
            public void run() {
                IntercomLogger.INTERNAL("polling", "conversation poll");
                Bridge.getApi().getConversation(conversationId);
                PollingManager.this.poll(PollingManager.this.conversationHandler, PollingManager.this.conversationPoller);
            }
        };
        this.poll(this.conversationHandler, this.conversationPoller);
    }

    public void startPreviewPolling() {
        IntercomLogger.INTERNAL("polling", "starting chathead polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.previewPoller);
    }

    public void startInboxPolling() {
        IntercomLogger.INTERNAL("polling", "starting inbox polling");
        this.handler.removeCallbacksAndMessages(null);
        this.poll(this.handler, this.inboxPoller);
    }

    public void throttledInboxPoll() {
        if (!this.currentlyThrottlingInboxPoll) {
            IntercomLogger.INTERNAL("throttled polling", "inbox poll scheduled");
            this.currentlyThrottlingInboxPoll = true;
            this.throttledPoll(this.handler, new Runnable(){

                @Override
                public void run() {
                    IntercomLogger.INTERNAL("throttled polling", "performing inbox poll");
                    Bridge.getApi().getInbox();
                    PollingManager.this.resetInboxPoll();
                    PollingManager.this.currentlyThrottlingInboxPoll = false;
                }
            });
        }
    }

    public void throttledConversationPoll(final String conversationId) {
        if (!this.currentlyThrottlingConversationPoll) {
            IntercomLogger.INTERNAL("throttled polling", "conversation poll scheduled");
            this.currentlyThrottlingConversationPoll = true;
            this.throttledPoll(this.conversationHandler, new Runnable(){

                @Override
                public void run() {
                    IntercomLogger.INTERNAL("throttled polling", "performing conversation poll");
                    Bridge.getApi().getConversation(conversationId);
                    if (PollingManager.this.conversationPoller != null) {
                        PollingManager.this.resetConversationPoll();
                    }
                    PollingManager.this.currentlyThrottlingConversationPoll = false;
                }
            });
        }
    }

    public void throttledPreviewPoll() {
        if (!this.currentlyThrottlingPreviewPoll) {
            IntercomLogger.INTERNAL("throttled polling", "preview poll scheduled");
            this.currentlyThrottlingPreviewPoll = true;
            this.throttledPoll(this.handler, new Runnable(){

                @Override
                public void run() {
                    IntercomLogger.INTERNAL("throttled polling", "performing preview poll");
                    Bridge.getApi().getUnreadConversations();
                    PollingManager.this.resetPreviewPoll();
                    PollingManager.this.currentlyThrottlingPreviewPoll = false;
                }
            });
        }
    }

    public void endPolling() {
        IntercomLogger.INTERNAL("polling", "ending polling");
        this.handler.removeCallbacksAndMessages(null);
        this.conversationHandler.removeCallbacksAndMessages(null);
        this.currentlyThrottlingConversationPoll = false;
        this.currentlyThrottlingInboxPoll = false;
        this.currentlyThrottlingPreviewPoll = false;
    }

    public void endConversationPolling() {
        IntercomLogger.INTERNAL("polling", "ending conversation polling");
        this.conversationHandler.removeCallbacksAndMessages(null);
        this.currentlyThrottlingConversationPoll = false;
    }

    public void resetConversationPoll() {
        IntercomLogger.INTERNAL("polling", "resetting conversation poller");
        this.conversationHandler.removeCallbacksAndMessages(null);
        this.poll(this.conversationHandler, this.conversationPoller);
    }

    public void resetInboxPoll() {
        IntercomLogger.INTERNAL("polling", "resetting inbox poller");
        this.handler.removeCallbacks(this.inboxPoller);
        this.poll(this.handler, this.inboxPoller);
    }

    public void resetPreviewPoll() {
        IntercomLogger.INTERNAL("polling", "resetting preview poller");
        this.handler.removeCallbacks(this.previewPoller);
        this.poll(this.handler, this.previewPoller);
    }

    private void poll(Handler handler, Runnable poller) {
        if (!Lifecycles.isAppBackgrounded()) {
            int pollingInterval = Bridge.getIdentityStore().getAppConfig().getPollingInterval();
            if (pollingInterval > 0) {
                handler.postDelayed(poller, TimeUnit.SECONDS.toMillis(pollingInterval));
            }
        } else {
            IntercomLogger.INTERNAL("polling", "ending polling because app is backgrounded");
        }
    }

    private void throttledPoll(Handler handler, Runnable poller) {
        if (!Lifecycles.isAppBackgrounded()) {
            int pollingInterval = Bridge.getIdentityStore().getAppConfig().getNoRealtimeThrottle();
            if (pollingInterval > 0) {
                handler.postDelayed(poller, TimeUnit.SECONDS.toMillis(pollingInterval));
            }
        } else {
            IntercomLogger.INTERNAL("throttled polling", "ignoring polling because app is backgrounded");
        }
    }
}

