/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit;

import io.intercom.retrofit.Callback;
import io.intercom.retrofit.ErrorHandler;
import io.intercom.retrofit.ResponseWrapper;
import io.intercom.retrofit.RetrofitError;
import java.util.concurrent.Executor;

abstract class CallbackRunnable<T>
implements Runnable {
    private final Callback<T> callback;
    private final Executor callbackExecutor;
    private final ErrorHandler errorHandler;

    CallbackRunnable(Callback<T> callback, Executor callbackExecutor, ErrorHandler errorHandler) {
        this.callback = callback;
        this.callbackExecutor = callbackExecutor;
        this.errorHandler = errorHandler;
    }

    @Override
    public final void run() {
        try {
            final ResponseWrapper wrapper = this.obtainResponse();
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.success(wrapper.responseBody, wrapper.response);
                }
            });
        }
        catch (RetrofitError e) {
            Throwable cause = this.errorHandler.handleError(e);
            final RetrofitError handled = cause == e ? e : RetrofitError.unexpectedError(e.getUrl(), cause);
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.failure(handled);
                }
            });
        }
    }

    public abstract ResponseWrapper obtainResponse();
}

