/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit.appengine;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import io.intercom.retrofit.client.Client;
import io.intercom.retrofit.client.Header;
import io.intercom.retrofit.client.Request;
import io.intercom.retrofit.client.Response;
import io.intercom.retrofit.mime.TypedByteArray;
import io.intercom.retrofit.mime.TypedOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UrlFetchClient
implements Client {
    private final URLFetchService urlFetchService;

    private static HTTPMethod getHttpMethod(String method) {
        if ("GET".equals(method)) {
            return HTTPMethod.GET;
        }
        if ("POST".equals(method)) {
            return HTTPMethod.POST;
        }
        if ("PATCH".equals(method)) {
            return HTTPMethod.PATCH;
        }
        if ("PUT".equals(method)) {
            return HTTPMethod.PUT;
        }
        if ("DELETE".equals(method)) {
            return HTTPMethod.DELETE;
        }
        if ("HEAD".equals(method)) {
            return HTTPMethod.HEAD;
        }
        throw new IllegalStateException("Illegal HTTP method: " + method);
    }

    public UrlFetchClient() {
        this(URLFetchServiceFactory.getURLFetchService());
    }

    public UrlFetchClient(URLFetchService urlFetchService) {
        this.urlFetchService = urlFetchService;
    }

    @Override
    public Response execute(Request request) throws IOException {
        HTTPRequest fetchRequest = UrlFetchClient.createRequest(request);
        HTTPResponse fetchResponse = this.execute(this.urlFetchService, fetchRequest);
        return UrlFetchClient.parseResponse(fetchResponse, fetchRequest);
    }

    protected HTTPResponse execute(URLFetchService urlFetchService, HTTPRequest request) throws IOException {
        return urlFetchService.fetch(request);
    }

    static HTTPRequest createRequest(Request request) throws IOException {
        HTTPMethod httpMethod = UrlFetchClient.getHttpMethod(request.getMethod());
        URL url = new URL(request.getUrl());
        HTTPRequest fetchRequest = new HTTPRequest(url, httpMethod);
        for (Header header : request.getHeaders()) {
            fetchRequest.addHeader(new HTTPHeader(header.getName(), header.getValue()));
        }
        TypedOutput body = request.getBody();
        if (body != null) {
            String mimeType = body.mimeType();
            if (mimeType != null) {
                fetchRequest.addHeader(new HTTPHeader("Content-Type", mimeType));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            body.writeTo(baos);
            fetchRequest.setPayload(baos.toByteArray());
        }
        return fetchRequest;
    }

    static Response parseResponse(HTTPResponse response, HTTPRequest creatingRequest) {
        URL responseUrl = response.getFinalUrl();
        String urlString = (responseUrl != null ? responseUrl : creatingRequest.getURL()).toString();
        int status = response.getResponseCode();
        List fetchHeaders = response.getHeaders();
        ArrayList<Header> headers = new ArrayList<Header>(fetchHeaders.size());
        String contentType = "application/octet-stream";
        for (HTTPHeader fetchHeader : fetchHeaders) {
            String name = fetchHeader.getName();
            String value = fetchHeader.getValue();
            if ("Content-Type".equalsIgnoreCase(name)) {
                contentType = value;
            }
            headers.add(new Header(name, value));
        }
        TypedByteArray body = null;
        byte[] fetchBody = response.getContent();
        if (fetchBody != null) {
            body = new TypedByteArray(contentType, fetchBody);
        }
        return new Response(urlString, status, "", headers, body);
    }
}

