/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.Logger;
import io.intercom.android.sdk.models.api.Config;

public class AppIdentity {
    private static final String API_PREFIX = "android_sdk-";
    private static final String PREFS_API_KEY = "ApiKey";
    private static final String PREFS_APP_ID = "AppId";
    private final SharedPreferences prefs;
    private final AppConfig appConfig;
    private String apiKey;
    private String appId;

    public AppIdentity(Context context) {
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.apiKey = this.prefs.getString(PREFS_API_KEY, "");
        this.appId = this.prefs.getString(PREFS_APP_ID, "");
        this.appConfig = new AppConfig(context);
    }

    protected boolean validateAppCredentials(String apiKey, String appId) {
        boolean isValid = false;
        if (apiKey.length() > 12 && !appId.isEmpty()) {
            String prefix = apiKey.substring(0, 12);
            if (prefix.equals(API_PREFIX) && apiKey.length() >= 52) {
                isValid = true;
            } else {
                Logger.ERROR("The api key provided either is too short or did not begin with 'android_sdk-'.\nPlease check that you are using an Intercom Android SDK key and have not passed the appId into the apiKey field\n");
            }
        }
        return isValid;
    }

    protected void update(String apiKey, String appId) {
        if (this.validateAppCredentials(apiKey, appId)) {
            SharedPreferences.Editor editor = this.prefs.edit();
            this.apiKey = apiKey;
            this.appId = appId;
            editor.putString(PREFS_API_KEY, apiKey);
            editor.putString(PREFS_APP_ID, appId);
            editor.apply();
        }
    }

    protected void updateAppConfig(Config config) {
        this.appConfig.update(config);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAppId() {
        return this.appId;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected boolean appIdentityExists() {
        return !this.apiKey.isEmpty() && !this.appId.isEmpty();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    protected void clear() {
        this.prefs.edit().clear().commit();
        this.apiKey = "";
        this.appId = "";
    }
}

