/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.picasso;

import android.graphics.Bitmap;
import android.net.NetworkInfo;
import io.intercom.com.squareup.picasso.Downloader;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.Request;
import io.intercom.com.squareup.picasso.RequestHandler;
import io.intercom.com.squareup.picasso.Stats;
import io.intercom.com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkRequestHandler
extends RequestHandler {
    static final int RETRY_COUNT = 2;
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final Downloader downloader;
    private final Stats stats;

    public NetworkRequestHandler(Downloader downloader, Stats stats) {
        this.downloader = downloader;
        this.stats = stats;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        String scheme = data.uri.getScheme();
        return SCHEME_HTTP.equals(scheme) || SCHEME_HTTPS.equals(scheme);
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        Downloader.Response response = this.downloader.load(request.uri, request.networkPolicy);
        if (response == null) {
            return null;
        }
        Picasso.LoadedFrom loadedFrom = response.cached ? Picasso.LoadedFrom.DISK : Picasso.LoadedFrom.NETWORK;
        Bitmap bitmap = response.getBitmap();
        if (bitmap != null) {
            return new RequestHandler.Result(bitmap, loadedFrom);
        }
        InputStream is = response.getInputStream();
        if (is == null) {
            return null;
        }
        if (loadedFrom == Picasso.LoadedFrom.DISK && response.getContentLength() == 0L) {
            Utils.closeQuietly(is);
            throw new ContentLengthException("Received response with 0 content-length header.");
        }
        if (loadedFrom == Picasso.LoadedFrom.NETWORK && response.getContentLength() > 0L) {
            this.stats.dispatchDownloadFinished(response.getContentLength());
        }
        return new RequestHandler.Result(is, loadedFrom);
    }

    @Override
    int getRetryCount() {
        return 2;
    }

    @Override
    boolean shouldRetry(boolean airplaneMode, NetworkInfo info) {
        return info == null || info.isConnected();
    }

    @Override
    boolean supportsReplay() {
        return true;
    }

    static class ContentLengthException
    extends IOException {
        public ContentLengthException(String message) {
            super(message);
        }
    }
}

