/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.TargetApi;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Gcm;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.activities.MainActivity;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.identity.Migrations;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricType;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.android.sdk.preview.IntercomPreviewPosition;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.IntercomUtils;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=14)
public class RealIntercom
extends Intercom {
    private final DeDuper superDeDuper;
    private final RateLimiter rateLimiter;
    private boolean initialised = false;

    protected RealIntercom(Application application, String apiKey, String appId) {
        if (!ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
            this.superDeDuper = null;
            this.rateLimiter = null;
            return;
        }
        IntercomUtils.changeComponentState(1, application.getApplicationContext());
        Bridge.initWithAppCredentials(application, apiKey, appId);
        Migrations.runAll(application.getApplicationContext());
        this.superDeDuper = Bridge.getDeDuper();
        this.rateLimiter = new RateLimiter(Bridge.getIdentityStore().getAppConfig());
        this.initialised = true;
    }

    @Override
    public void registerUnidentifiedUser() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (Bridge.getIdentityStore().registerUnidentifiedUser()) {
            Bridge.getMetricsStore().increment(MetricType.REGISTER_UNIDENTIFIED);
            Bridge.getApi().registerUnidentifiedUser();
        } else {
            IntercomLogger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)");
        }
    }

    @Override
    public void registerIdentifiedUser(Registration userRegistration) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (userRegistration != null) {
            if (Bridge.getIdentityStore().registerIdentifiedUser(userRegistration)) {
                Bridge.getMetricsStore().increment(MetricType.REGISTER_IDENTIFIED);
                Bridge.getApi().registerIdentifiedUser(userRegistration);
            } else {
                IntercomLogger.INFO("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to change the user call update instead.");
            }
        } else {
            IntercomLogger.ERROR("The registration object you passed to is null. An example successful call is registerIdentifiedUser(new Registration().withEmail(email));");
        }
    }

    @Override
    public void setSecureMode(String secureHash, String secureData) {
        if (this.initialised) {
            if (TextUtils.isEmpty((CharSequence)secureHash)) {
                IntercomLogger.WARNING("The hmac you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without a valid hmac.");
            } else if (TextUtils.isEmpty((CharSequence)secureData)) {
                IntercomLogger.WARNING("The data you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without valid data.");
            } else {
                Bridge.getIdentityStore().setSecureMode(secureHash, secureData);
            }
        }
    }

    @Override
    public void updateUser(Map<String, ?> attributes) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (attributes == null) {
            IntercomLogger.ERROR("updateUser method failed: the attributes Map provided is null");
        } else if (attributes.isEmpty()) {
            IntercomLogger.ERROR("updateUser method failed: the attributes Map provided is empty");
        } else if (attributes.getClass().isAnonymousClass()) {
            IntercomLogger.ERROR("updateUser method failed: the attributes Map provided is an anonymous subclass");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.ERROR("Your app is being rate limited because you're performing too many requests per minute");
            Bridge.getMetricsStore().increment(MetricType.LOCAL_RATE_LIMITED);
        } else {
            this.rateLimiter.increment();
            if (Bridge.getIdentityStore().isAnonymousUser()) {
                AttributeSanitiser.anonymousSanitisation(attributes);
            }
            if (this.superDeDuper.shouldUpdateUser(attributes)) {
                this.superDeDuper.setAttributes(attributes);
                Bridge.getMetricsStore().increment(MetricType.UPDATE_USER);
                Bridge.getApi().updateUser(attributes);
                IntercomLogger.INTERNAL("dupe", "updated user");
            } else {
                Bridge.getMetricsStore().increment(MetricType.UPDATE_USER_DUP);
                IntercomLogger.INTERNAL("dupe", "dropped dupe");
            }
        }
    }

    @Override
    public void logEvent(String name) {
        this.logEventWithValidation(name, new HashMap());
    }

    @Override
    public void logEvent(String name, Map<String, ?> metadata) {
        if (metadata == null) {
            IntercomLogger.INFO("The metadata provided is null, logging event with no metadata");
            metadata = new HashMap();
        } else if (!metadata.isEmpty()) {
            IntercomLogger.INFO("The metadata provided is empty, logging event with no metadata");
        }
        this.logEventWithValidation(name, metadata);
    }

    private void logEventWithValidation(String name, Map<String, ?> metadata) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            IntercomLogger.ERROR("The event name is null or empty. We can't log an event with this string.");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.ERROR("Your app is being rate limited because you're performing too many requests per minute");
            Bridge.getMetricsStore().increment(MetricType.LOCAL_RATE_LIMITED);
        } else {
            this.rateLimiter.increment();
            Bridge.getApi().logEvent(name, metadata);
        }
    }

    @Override
    public void displayMessageComposer() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (Bridge.getIdentityStore().getAppConfig().isInboundMessages()) {
            this.openIAM(false, null, "");
        } else {
            IntercomLogger.ERROR("It appears your app is not on a plan that allows message composing As a fallback we are calling displayConversationsList()");
            this.displayConversationsList();
        }
    }

    @Override
    public void displayConversationsList() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        this.openIAM(true, null, "");
    }

    private void openIAM(boolean asConversationsList, TaskStackBuilder customStack, String conversationId) {
        if (this.initialised) {
            Context context = Bridge.getContext();
            Intent intent = new Intent(context, MainActivity.class);
            if (asConversationsList) {
                intent.putExtra("showInbox", true);
                Bridge.getMetricsStore().increment(MetricType.OPENED_CONVERSATION_LIST);
            } else {
                Conversation conversation = new Conversation.Builder().withId(conversationId).build();
                intent.putExtra("OpenConversation", (Parcelable)conversation);
                Bridge.getMetricsStore().increment(MetricType.OPENED_COMPOSER);
            }
            intent.addFlags(0x10000000);
            if (customStack != null && Build.VERSION.SDK_INT >= 16) {
                customStack.addNextIntent(intent);
                context.startActivities(customStack.getIntents());
            } else {
                context.startActivity(intent);
            }
        }
    }

    @Override
    public void setPreviewPosition(IntercomPreviewPosition previewPosition) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (previewPosition == null) {
            IntercomLogger.WARNING("The previewPosition provided is null so we are defaulting to bottom left. An example correct call is: setPreviewPosition(IntercomPreviewPosition.BOTTOM_LEFT);");
            previewPosition = IntercomPreviewPosition.BOTTOM_LEFT;
        }
        Bridge.getPreviewManager().setPresentationMode(previewPosition);
    }

    @Override
    public void setVisibility(int visibility) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        if (visibility == 0 || visibility == 8) {
            Bridge.getPreviewManager().setVisibility(visibility);
            if (visibility == 8) {
                Bridge.getBus().post((Object)new CloseIAMEvent());
            }
        } else {
            IntercomLogger.ERROR("Visibility can only be Intercom.VISIBLE or Intercom.GONE");
        }
    }

    @Override
    @Deprecated
    public void setMessagesHidden(boolean visibility) {
        this.setVisibility(visibility ? 0 : 8);
    }

    @Override
    public void setupGCM(String regId, int appLogo) {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        Context context = Bridge.getContext();
        PackageManager packageManager = context.getPackageManager();
        if (packageManager.checkPermission("com.google.android.c2dm.permission.RECEIVE", context.getPackageName()) == 0 && packageManager.checkPermission("android.permission.WAKE_LOCK", context.getPackageName()) == 0 && packageManager.checkPermission("android.permission.VIBRATE", context.getPackageName()) == 0) {
            if (Gcm.gcmModuleInstalled()) {
                if (Gcm.isGcmEnabled(context)) {
                    if (TextUtils.isEmpty((CharSequence)regId)) {
                        IntercomLogger.ERROR("The GCM registrationId  passed in is null or empty, we require a valid GCM registrationId to enable push");
                    } else {
                        SharedPreferences settings = Bridge.getContext().getSharedPreferences("INTERCOM_SDK_PREFS", 0);
                        SharedPreferences.Editor editor = settings.edit();
                        editor.putInt("INTERCOM_SDK_PUSH_LOGO", appLogo);
                        editor.apply();
                        if (!DeviceData.hasCachedPushToken(Bridge.getContext(), regId)) {
                            Bridge.getApi().setGCMPushKey(regId);
                            DeviceData.cachePushToken(Bridge.getContext(), regId);
                        }
                    }
                } else {
                    IntercomLogger.ERROR("GCM components are disabled on gingerbread devices");
                }
            } else {
                IntercomLogger.ERROR("intercom-sdk-gcm module not found. Please add it to your build.gradle");
            }
        } else {
            IntercomLogger.ERROR("To enable GCM notifications the following permissions are required. <uses-permission android:name=\"android.permission.WAKE_LOCK\" />\n<uses-permission android:name=\"com.google.android.c2dm.permission.RECEIVE\" />\n<uses-permission android:name=\"android.permission.VIBRATE\"/>\nIn addition to the required permissions the following optional permissions improve push reliability<uses-permission android:name=\"android.permission.READ_PHONE_STATE\"/>\n<uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
        }
    }

    @Override
    public void openGCMMessage(Intent intent) {
        this.openGCMMessage(intent, null);
    }

    @Override
    public void openGCMMessage(Intent intent, TaskStackBuilder customStack) {
        boolean launchedFromHistory;
        boolean bl = launchedFromHistory = intent != null && (intent.getFlags() & 0x100000) != 0;
        if (!launchedFromHistory) {
            if (!this.isInitialised()) {
                this.logIntercomNotInitialised();
                return;
            }
            if (intent != null && intent.getData() != null) {
                Context context = Bridge.getContext();
                int pushOnlyId = intent.getIntExtra("push_only_convo_id", -1);
                if (pushOnlyId != -1) {
                    Bridge.getApi().markConversationAsRead(String.valueOf(pushOnlyId));
                }
                if (!intent.getDataString().isEmpty() && pushOnlyId != -1) {
                    this.openPushOnlyMessage(intent, context);
                } else {
                    this.openIntercomChatPush(intent, customStack);
                }
            } else {
                IntercomLogger.INFO("The Uri passed into the method openGCMMessage was null.");
            }
        }
    }

    private void openPushOnlyMessage(Intent intent, Context context) {
        Intent notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)intent.getDataString()));
        notificationIntent.addFlags(0x10000000);
        if (notificationIntent.resolveActivity(context.getPackageManager()) != null) {
            context.startActivity(notificationIntent);
            Bridge.getMetricsStore().increment(MetricType.OPENED_PUSH_MESSAGE);
        } else {
            IntercomLogger.INFO("This device has no application that can handlethe Uri passed in");
        }
    }

    private void openIntercomChatPush(Intent intent, TaskStackBuilder customStack) {
        List pathParts = intent.getData().getPathSegments();
        if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals("intercom_sdk")) {
            Bridge.getMetricsStore().increment(MetricType.OPENED_PUSH_MESSAGE);
            if (((String)pathParts.get(1)).equals("multiple_notifications")) {
                this.openIAM(true, customStack, "");
            } else {
                this.openIAM(false, customStack, ((String)pathParts.get(1)).substring(((String)pathParts.get(1)).lastIndexOf(61) + 1));
            }
            Gcm.clearNotifications(Bridge.getContext());
        } else {
            IntercomLogger.INFO("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
        }
    }

    @Override
    @Deprecated
    public boolean openGCMMessage(Uri data) {
        boolean wasSdkPush = false;
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return wasSdkPush;
        }
        if (data != null) {
            List pathParts = data.getPathSegments();
            if (pathParts.size() > 1 && ((String)pathParts.get(0)).equals("intercom_sdk")) {
                wasSdkPush = true;
                if (((String)pathParts.get(1)).equals("multiple_notifications")) {
                    this.openIAM(true, null, "");
                } else {
                    this.openIAM(false, null, ((String)pathParts.get(1)).substring(((String)pathParts.get(1)).lastIndexOf(61) + 1));
                }
                Gcm.clearNotifications(Bridge.getContext());
            } else {
                IntercomLogger.INFO("The Uri passed into the method openGCMMessage was not an Intercom GCM message");
            }
        } else {
            IntercomLogger.INFO("The Uri passed into the method openGCMMessage was null.");
        }
        if (wasSdkPush) {
            Bridge.getMetricsStore().increment(MetricType.OPENED_PUSH_MESSAGE);
        }
        return wasSdkPush;
    }

    @Override
    public void reset() {
        if (!this.isInitialised()) {
            this.logIntercomNotInitialised();
            return;
        }
        Bridge.getApi().removeGCMDeviceToken(DeviceData.getPushToken(Bridge.getContext()));
        Bridge.getIdentityStore().getAppConfig().resetRealTimeConfig();
        Bridge.getNexusClient().disconnect();
        Bridge.getIdentityStore().resetUserIdentity();
        Bridge.getBus().post((Object)new CloseIAMEvent());
        Bridge.getPreviewManager().reset();
        Bridge.getMetricsStore().increment(MetricType.RESET);
        IntercomLogger.INFO("Successfully reset user. To resume communicating with Intercom, you can register a user");
    }

    private boolean isInitialised() {
        return this.initialised;
    }

    private void logIntercomNotInitialised() {
        IntercomLogger.ERROR("It appears Intercom has not been initialized correctly. Please make sure the first Intercom method you call is initialize and that you're passing in the correct app id and api-key");
    }
}

