/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Spanned;
import android.text.method.MovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.SubheadngBlock;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;

public class Subheading
implements SubheadngBlock {
    private final LayoutInflater inflater;
    private final StyleType style;

    public Subheading(Context context, StyleType style) {
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public View addSubheading(Spanned text, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case ADMIN: 
            case ANNOUNCEMENT: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_subheading, parent, false);
                int color2 = Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor());
                textview.setTextColor(color2);
                textview.setLinkTextColor(color2);
                break;
            }
            case WELCOME: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_subheading, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_subheading, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        textview.setText((CharSequence)text);
        textview.setGravity(alignment.getGravity());
        BlockUtils.setLayoutMarginsAndGravity((View)textview, alignment.getGravity(), isLastObject);
        return textview;
    }
}

