/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.Events.FirstMessageEvent;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class AppConfig {
    private static final String APP_COLOR = "app_color";
    private static final String APP_POWERED_BY = "app_powered_by";
    private static final String APP_FIRST_REQUEST = "app_is_first_request";
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    private static final String APP_WELCOME_MESSAGE = "app_welcome_message";
    private static final String APP_POLLING_INTERVAL = "app_polling_interval";
    private static final String APP_NO_REAL_TIME_THROTTLE = "app_no_real_time_throttle";
    private static final String APP_USER_UPDATE_CACHE_MAX_AGE = "app_user_update_cache_max_age";
    private static final String APP_RATE_LIMIT_PERIOD = "app_rate_limit_period";
    private static final String APP_RATE_LIMIT_COUNT = "app_rate_limit_count";
    private static final String APP_REAL_TIME = "app_real_time";
    private static final String APP_MESSAGE_RESPONSE = "app_message_response";
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    private final SharedPreferences prefs;
    private final Gson gson;
    private NexusConfig realTimeConfig = new NexusConfig();
    private List<Block> welcomeMessage = new ArrayList<Block>();
    private Drawable baseColorAvatar;
    private String baseColor = "";
    private String messageResponse = "";
    private int pollingInterval;
    private int noRealtimeThrottle;
    private int userUpdateCacheMaxAge;
    private int rateLimitPeriod;
    private int rateLimitCount;
    private boolean isFirstRequest;
    private boolean inboundMessages;
    private boolean showPoweredBy;
    private boolean realTime;
    private boolean audioEnabled;

    public AppConfig(Context context, Gson gson) {
        this.gson = gson;
        this.prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        this.welcomeMessage = this.setUpWelcomeMessage();
        this.baseColor = this.prefs.getString(APP_COLOR, String.format("#%06X", 0xFFFFFF & context.getResources().getColor(R.color.intercomsdk_main_blue)));
        this.baseColorAvatar = this.createColoredAvatar(context, Color.parseColor((String)this.baseColor));
        this.showPoweredBy = this.prefs.getBoolean(APP_POWERED_BY, false);
        this.isFirstRequest = this.prefs.getBoolean(APP_FIRST_REQUEST, false);
        this.inboundMessages = this.prefs.getBoolean(APP_INBOUND_MESSAGES, false);
        this.pollingInterval = this.prefs.getInt(APP_POLLING_INTERVAL, 0);
        this.noRealtimeThrottle = this.prefs.getInt(APP_NO_REAL_TIME_THROTTLE, 0);
        this.userUpdateCacheMaxAge = this.prefs.getInt(APP_USER_UPDATE_CACHE_MAX_AGE, 0);
        this.rateLimitPeriod = this.prefs.getInt(APP_RATE_LIMIT_PERIOD, 60);
        this.rateLimitCount = this.prefs.getInt(APP_RATE_LIMIT_COUNT, Integer.MAX_VALUE);
        this.realTime = this.prefs.getBoolean(APP_REAL_TIME, false);
        this.messageResponse = this.prefs.getString(APP_MESSAGE_RESPONSE, "");
        this.audioEnabled = this.prefs.getBoolean(APP_AUDIO_ENABLED, true);
    }

    protected void update(Config config) {
        if (this.isNewConfig(config)) {
            boolean nexusConfigChanged = !config.getRealTimeConfig().equals((Object)this.realTimeConfig);
            boolean colourChanged = !config.getBaseColor().equals(this.baseColor);
            this.welcomeMessage = config.getWelcomeMessage();
            this.baseColor = config.getBaseColor();
            this.isFirstRequest = config.isFirstRequest();
            this.inboundMessages = config.isInboundMessages();
            this.showPoweredBy = config.isShowPoweredBy();
            this.audioEnabled = config.isAudioEnabled();
            this.realTime = config.isRealTime();
            this.pollingInterval = config.getPollingInterval();
            this.noRealtimeThrottle = config.getNoRealtimeThrottle();
            this.userUpdateCacheMaxAge = config.getUserUpdateCacheMaxAge();
            this.rateLimitPeriod = config.getRateLimitPeriod();
            this.rateLimitCount = config.getRateLimitCount();
            this.messageResponse = config.getMessageResponse();
            this.realTimeConfig = config.getRealTimeConfig();
            SharedPreferences.Editor editor = this.prefs.edit();
            editor.putString(APP_WELCOME_MESSAGE, this.convertWelcomeMessageToJson());
            editor.putString(APP_COLOR, this.baseColor);
            editor.putString(APP_MESSAGE_RESPONSE, this.messageResponse);
            editor.putInt(APP_POLLING_INTERVAL, this.pollingInterval);
            editor.putInt(APP_NO_REAL_TIME_THROTTLE, this.noRealtimeThrottle);
            editor.putInt(APP_USER_UPDATE_CACHE_MAX_AGE, this.userUpdateCacheMaxAge);
            editor.putInt(APP_RATE_LIMIT_COUNT, this.rateLimitCount);
            editor.putInt(APP_RATE_LIMIT_PERIOD, this.rateLimitPeriod);
            editor.putBoolean(APP_POWERED_BY, this.showPoweredBy);
            editor.putBoolean(APP_FIRST_REQUEST, this.isFirstRequest);
            editor.putBoolean(APP_INBOUND_MESSAGES, this.inboundMessages);
            editor.putBoolean(APP_AUDIO_ENABLED, this.audioEnabled);
            editor.putBoolean(APP_REAL_TIME, this.realTime);
            editor.apply();
            if (this.isFirstRequest) {
                Bridge.getBus().post((Object)new FirstMessageEvent());
            }
            if (nexusConfigChanged) {
                Bridge.getNexusClient().cycle(this.realTimeConfig, true);
            }
            if (colourChanged) {
                this.baseColorAvatar = this.createColoredAvatar(Bridge.getContext(), Color.parseColor((String)this.baseColor));
            }
        }
    }

    private List<Block> setUpWelcomeMessage() {
        String json = this.prefs.getString(APP_WELCOME_MESSAGE, "");
        List blocks = null;
        try {
            blocks = (List)this.gson.fromJson(json, new TypeToken<List<Block>>(){}.getType());
        }
        catch (AssertionError e) {
            IntercomLogger.WARNING("Failed to parse JSON for welcome message");
        }
        return blocks == null ? new ArrayList() : blocks;
    }

    private String convertWelcomeMessageToJson() {
        String result;
        try {
            result = this.gson.toJson(this.welcomeMessage);
        }
        catch (AssertionError e) {
            IntercomLogger.WARNING("Failed to parse JSON for welcome message");
            result = "";
        }
        return result;
    }

    public List<Block> getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getBaseColor() {
        return this.baseColor;
    }

    public Drawable getBaseColorAvatar() {
        return this.baseColorAvatar;
    }

    public boolean isShowPoweredBy() {
        return this.showPoweredBy;
    }

    public boolean isInboundMessages() {
        return this.inboundMessages;
    }

    public boolean isFirstRequest() {
        return this.isFirstRequest;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getNoRealtimeThrottle() {
        return this.noRealtimeThrottle;
    }

    public int getUserUpdateCacheMaxAge() {
        return this.userUpdateCacheMaxAge;
    }

    public int getRateLimitPeriod() {
        return this.rateLimitPeriod;
    }

    public int getRateLimitCount() {
        return this.rateLimitCount;
    }

    public boolean isRealTime() {
        return this.realTime && !this.realTimeConfig.getEndpoints().isEmpty();
    }

    public NexusConfig getRealTimeConfig() {
        return this.realTimeConfig;
    }

    public String getMessageResponse() {
        return this.messageResponse;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    public void resetRealTimeConfig() {
        this.realTimeConfig = new NexusConfig();
    }

    private boolean isNewConfig(Config config) {
        return !config.getMessageResponse().equals(this.messageResponse) || !config.getWelcomeMessage().equals(this.welcomeMessage) || !config.getRealTimeConfig().equals((Object)this.realTimeConfig) || !config.getBaseColor().equals(this.baseColor) || config.getPollingInterval() != this.pollingInterval || config.getNoRealtimeThrottle() != this.noRealtimeThrottle || config.getUserUpdateCacheMaxAge() != this.userUpdateCacheMaxAge || config.isAudioEnabled() != this.audioEnabled || config.isRealTime() != this.realTime || config.isShowPoweredBy() != this.showPoweredBy || config.isInboundMessages() != this.inboundMessages || config.isFirstRequest() != this.isFirstRequest || config.getRateLimitCount() != this.rateLimitCount || config.getRateLimitPeriod() != this.rateLimitPeriod;
    }

    private Drawable createColoredAvatar(Context context, int baseColor) {
        Bitmap originalAvatar;
        Bitmap newAvatar = originalAvatar = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.intercomsdk_avatar);
        int originalColor = context.getResources().getColor(R.color.intercomsdk_main_blue);
        if (originalColor != baseColor) {
            int width = originalAvatar.getWidth();
            int height = originalAvatar.getHeight();
            if (width > 0 && height > 0) {
                int[] pixelArray = new int[width * height];
                originalAvatar.getPixels(pixelArray, 0, width, 0, 0, width, height);
                for (int pixel = 0; pixel < pixelArray.length; ++pixel) {
                    pixelArray[pixel] = pixelArray[pixel] == originalColor ? baseColor : pixelArray[pixel];
                }
                newAvatar = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)originalAvatar.getConfig());
                newAvatar.setPixels(pixelArray, 0, width, 0, 0, width, height);
            }
        }
        return new BitmapDrawable(context.getResources(), newAvatar);
    }
}

