/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit.client;

import io.intercom.retrofit.client.Header;
import io.intercom.retrofit.mime.TypedOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Request {
    private final String method;
    private final String url;
    private final List<Header> headers;
    private final TypedOutput body;

    public Request(String method, String url, List<Header> headers, TypedOutput body) {
        if (method == null) {
            throw new NullPointerException("Method must not be null.");
        }
        if (url == null) {
            throw new NullPointerException("URL must not be null.");
        }
        this.method = method;
        this.url = url;
        this.headers = headers == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Header>(headers));
        this.body = body;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public TypedOutput getBody() {
        return this.body;
    }
}

