/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.transforms;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import com.squareup.picasso.Transformation;

public class RoundedCornersTransform
implements Transformation {
    private int radius;

    public RoundedCornersTransform(int radius) {
        this.radius = radius;
    }

    public Bitmap transform(Bitmap source) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Bitmap output = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight()), (float)this.radius, (float)this.radius, paint);
        if (source != output) {
            source.recycle();
        }
        return output;
    }

    public String key() {
        return "rounded(radius=" + this.radius + ")";
    }
}

