/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.servicecommon;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.webserver.servicecommon.RestServiceSettingsImpl;

public interface RestServiceSettings {
    public static RestServiceSettings create() {
        return RestServiceSettings.builder().build();
    }

    public static RestServiceSettings create(Config config) {
        return RestServiceSettings.builder().config(config).build();
    }

    public static Builder builder() {
        return RestServiceSettingsImpl.Builder.create();
    }

    public String webContext();

    public String routing();

    public CrossOriginConfig crossOriginConfig();

    public boolean enabled();

    @Configured
    public static interface Builder
    extends io.helidon.common.Builder<Builder, RestServiceSettings> {
        public static final String ROUTING_NAME_CONFIG_KEY = "routing";
        public static final String WEB_CONTEXT_CONFIG_KEY = "web-context";

        @ConfiguredOption(key="web-context", mergeWithParent=true)
        public Builder webContext(String var1);

        @ConfiguredOption(key="routing", mergeWithParent=true)
        public Builder routing(String var1);

        @ConfiguredOption(key="cors", type=CrossOriginConfig.class, kind=ConfiguredOption.Kind.MAP)
        public Builder crossOriginConfig(CrossOriginConfig.Builder var1);

        @ConfiguredOption(value="true", mergeWithParent=true)
        public Builder enabled(boolean var1);

        public Builder crossOriginConfig(CrossOriginConfig var1);

        public Builder config(Config var1);

        public RestServiceSettings build();
    }
}

