/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.media.type.MediaType;
import io.helidon.config.Config;
import io.helidon.config.MetaConfigFinder;
import io.helidon.config.MetaProviders;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.RetryPolicy;
import io.helidon.service.registry.Service;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;

@Service.Provider
public final class MetaConfig {
    private static final System.Logger LOGGER = System.getLogger(MetaConfig.class.getName());
    private static final Set<MediaType> SUPPORTED_MEDIA_TYPES;
    private static final List<String> SUPPORTED_SUFFIXES;
    private final Config metaConfig = MetaConfig.metaConfig().orElseGet(Config::empty);

    MetaConfig() {
    }

    public static Config config() {
        return MetaConfig.metaConfig().map(MetaConfig::config).orElseGet(MetaConfig::createDefault);
    }

    public static Config config(Config metaConfig) {
        return Config.builder().config(metaConfig).build();
    }

    public static Optional<Config> metaConfig() {
        return MetaConfigFinder.findMetaConfig(SUPPORTED_MEDIA_TYPES::contains, SUPPORTED_SUFFIXES);
    }

    public static PollingStrategy pollingStrategy(Config metaConfig) {
        return MetaProviders.pollingStrategy((String)metaConfig.get("type").asString().get(), metaConfig.get("properties"));
    }

    public static ChangeWatcher<?> changeWatcher(Config metaConfig) {
        String type = (String)metaConfig.get("type").asString().get();
        ChangeWatcher<?> changeWatcher = MetaProviders.changeWatcher(type, metaConfig.get("properties"));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Loaded change watcher of type \"" + type + "\", class: " + changeWatcher.getClass().getName());
        }
        return changeWatcher;
    }

    public static RetryPolicy retryPolicy(Config metaConfig) {
        String type = (String)metaConfig.get("type").asString().get();
        RetryPolicy retryPolicy = MetaProviders.retryPolicy(type, metaConfig.get("properties"));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Loaded retry policy of type \"" + type + "\", class: " + retryPolicy.getClass().getName());
        }
        return retryPolicy;
    }

    public static List<ConfigSource> configSource(Config sourceMetaConfig) {
        String type = (String)sourceMetaConfig.get("type").asString().get();
        boolean multiSource = (Boolean)sourceMetaConfig.get("multi-source").asBoolean().orElse((Object)false);
        Config sourceProperties = sourceMetaConfig.get("properties");
        if (multiSource) {
            List<ConfigSource> sources = MetaProviders.configSources(type, sourceProperties);
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Loaded sources of type \"" + type + "\", values: " + String.valueOf(sources));
            }
            return sources;
        }
        ConfigSource source = MetaProviders.configSource(type, sourceProperties);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Loaded source of type \"" + type + "\", class: " + source.getClass().getName());
        }
        return List.of(source);
    }

    public Config metaConfiguration() {
        return this.metaConfig;
    }

    static OverrideSource overrideSource(Config sourceMetaConfig) {
        String type = (String)sourceMetaConfig.get("type").asString().get();
        OverrideSource source = MetaProviders.overrideSource(type, sourceMetaConfig.get("properties"));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "Loaded override source of type \"" + type + "\", class: " + source.getClass().getName());
        }
        return source;
    }

    static List<ConfigSource> configSources(Config metaConfig) {
        LinkedList<ConfigSource> configSources = new LinkedList<ConfigSource>();
        metaConfig.get("sources").asNodeList().ifPresent(list -> list.forEach(it -> configSources.addAll(MetaConfig.configSource(it))));
        return configSources;
    }

    static List<ConfigSource> configSources(Function<MediaType, Boolean> supportedMediaType, List<String> supportedSuffixes) {
        Optional<Config> metaConfigOpt = MetaConfig.metaConfig();
        return metaConfigOpt.map(MetaConfig::configSources).orElseGet(() -> MetaConfigFinder.findConfigSource(supportedMediaType, supportedSuffixes).map(List::of).orElseGet(List::of));
    }

    private static Config createDefault() {
        Config.Builder builder = Config.builder();
        MetaConfigFinder.findConfigSource(SUPPORTED_MEDIA_TYPES::contains, SUPPORTED_SUFFIXES).ifPresent(builder::addSource);
        return builder.build();
    }

    static {
        HashSet supportedMediaTypes = new HashSet();
        LinkedList supportedSuffixes = new LinkedList();
        HelidonServiceLoader.create(ServiceLoader.load(ConfigParser.class)).forEach(parser -> {
            supportedMediaTypes.addAll(parser.supportedMediaTypes());
            supportedSuffixes.addAll(parser.supportedSuffixes());
        });
        SUPPORTED_MEDIA_TYPES = Set.copyOf(supportedMediaTypes);
        SUPPORTED_SUFFIXES = List.copyOf(supportedSuffixes);
    }
}

